SELECT
    `_all_wo_nds` AS `all_wo_nds`,
    `_caption` AS `caption`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_domain` AS `domain`,
    `_login` AS `login`,
    `_outdoor_all_wo_nds` AS `outdoor_all_wo_nds`,
    `_outdoor_block_all_hits` AS `outdoor_block_all_hits`,
    `_outdoor_block_bad_shows` AS `outdoor_block_bad_shows`,
    `_outdoor_block_bad_shows_own_adv` AS `outdoor_block_bad_shows_own_adv`,
    `_outdoor_block_bad_shows_percent` AS `outdoor_block_bad_shows_percent`,
    `_outdoor_block_bad_win_hits` AS `outdoor_block_bad_win_hits`,
    `_outdoor_block_bad_win_hits_own_adv` AS `outdoor_block_bad_win_hits_own_adv`,
    `_outdoor_block_bad_win_hits_percent` AS `outdoor_block_bad_win_hits_percent`,
    `_outdoor_block_bad_win_hits_unsold` AS `outdoor_block_bad_win_hits_unsold`,
    `_outdoor_block_cover_ratio` AS `outdoor_block_cover_ratio`,
    `_outdoor_block_cpm_all_wo_nds` AS `outdoor_block_cpm_all_wo_nds`,
    `_outdoor_block_cpm_partner_wo_nds` AS `outdoor_block_cpm_partner_wo_nds`,
    `_outdoor_block_cpmh_all_wo_nds` AS `outdoor_block_cpmh_all_wo_nds`,
    `_outdoor_block_cpmh_partner_wo_nds` AS `outdoor_block_cpmh_partner_wo_nds`,
    `_outdoor_block_direct_clicks` AS `outdoor_block_direct_clicks`,
    `_outdoor_block_direct_ctr` AS `outdoor_block_direct_ctr`,
    `_outdoor_block_direct_shows` AS `outdoor_block_direct_shows`,
    `_outdoor_block_hits` AS `outdoor_block_hits`,
    `_outdoor_block_hits_own_adv` AS `outdoor_block_hits_own_adv`,
    `_outdoor_block_hits_unsold` AS `outdoor_block_hits_unsold`,
    `_outdoor_block_shows` AS `outdoor_block_shows`,
    `_outdoor_block_shows_own_adv` AS `outdoor_block_shows_own_adv`,
    `_outdoor_block_visibility` AS `outdoor_block_visibility`,
    `_outdoor_block_winrate` AS `outdoor_block_winrate`,
    `_outdoor_partner_wo_nds` AS `outdoor_partner_wo_nds`,
    `_page_id` AS `page_id`,
    `_partner_wo_nds` AS `partner_wo_nds`,
    `_public_id` AS `public_id`
FROM (
    SELECT
        round((SUM((`all_wo_nds` / 1000)) / 10000000), 2) AS `_all_wo_nds`,
        dictGetString('pages_dict', 'caption', toUInt64(`page_id`)) AS `_caption`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_domain`,
        dictGetString('users_dict', 'login', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) AS `_login`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'outdoor_block') / 10000000), 2) AS `_outdoor_all_wo_nds`,
        sumIf(`win_max_positions_count`, `product_id` = 'outdoor_block') AS `_outdoor_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'outdoor_block'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'outdoor_block'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'outdoor_block'
            )))) AS `_outdoor_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            )))) AS `_outdoor_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'outdoor_block'
            )) * 100) / sumIf(`win_max_positions_count`, `product_id` = 'outdoor_block')) AS `_outdoor_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'outdoor_block') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'outdoor_block'
            ))), 2) AS `_outdoor_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'outdoor_block') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'outdoor_block'
            ))), 2) AS `_outdoor_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'outdoor_block') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            ))), 2) AS `_outdoor_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'outdoor_block') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            ))), 2) AS `_outdoor_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'outdoor_block'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'outdoor_block')) AS `_outdoor_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'outdoor_block') AS `_outdoor_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_hits_own_adv`,
        (sumIf(`win_max_positions_count`, `product_id` = 'outdoor_block') - (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'outdoor_block'
            )))) AS `_outdoor_block_hits_unsold`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'outdoor_block'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'outdoor_block'
        ))) AS `_outdoor_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'outdoor_block'
            )) + (sumIf(`win_max_positions_count`, `product_id` = 'outdoor_block') - (sumIf(`hits`, (
                        `dsp_id` NOT IN (5, 10)
                        AND `product_id` = 'outdoor_block'
                    )) + sumIf(`hits`, (
                        `dsp_id` = 5
                        AND `product_id` = 'outdoor_block'
                    )))))) AS `_outdoor_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'outdoor_block') / 10000000), 2) AS `_outdoor_partner_wo_nds`,
        `page_id` AS `_page_id`,
        round((SUM((`partner_wo_nds` / 1000)) / 10000000), 2) AS `_partner_wo_nds`,
        concat(transform(toString(`product_id`), ['outdoor_block'], ['O-D-']), toString(`page_id`), '-', toString(`block_id`)) AS `_public_id`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('outdoor_block')
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) IN ('id__from_table__users__with_filter__["AND",[["login","=","mock__owner-login"]]]')
        )
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) IN ('id__from_table__users__with_filter__["AND",[["is_tutby","=",1]]]')
        )
        AND (
            `page_id` = 'mock__page_id'
        )
        AND (
            'outdoor.ya' = 'mock__domain'
        )
        AND (
            (`page_id`) IN (('page_id__from_table__outdoor__with_filter__["AND",[[{"json_unquote":[{"json_extract":["opts","$.caption"]}]},"=","mock__caption"]]]'))
        )
        AND (
            dictGetUInt64('pages_dict', 'multistate', toUInt64(`page_id`)) IN ('mock_multistate')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
    )
    GROUP BY `_caption`, `_currency_id`, `_date`, `_domain`, `_login`, `_page_id`, `_public_id`
) `statistics`
WHERE (
    (if(isNaN(`outdoor_block_direct_shows`), 0, `outdoor_block_direct_shows`) + if(isNaN(`outdoor_block_visibility`), 0, `outdoor_block_visibility`) + if(isNaN(`outdoor_block_all_hits`), 0, `outdoor_block_all_hits`) + if(isNaN(`outdoor_block_cpm_partner_wo_nds`), 0, `outdoor_block_cpm_partner_wo_nds`) + if(isNaN(`outdoor_block_cpmh_partner_wo_nds`), 0, `outdoor_block_cpmh_partner_wo_nds`) + if(isNaN(`outdoor_block_bad_win_hits_unsold`), 0, `outdoor_block_bad_win_hits_unsold`) + if(isNaN(`outdoor_block_bad_shows_own_adv`), 0, `outdoor_block_bad_shows_own_adv`) + if(isNaN(`outdoor_block_shows_own_adv`), 0, `outdoor_block_shows_own_adv`) + if(isNaN(`outdoor_block_hits_own_adv`), 0, `outdoor_block_hits_own_adv`) + if(isNaN(`outdoor_block_cpm_all_wo_nds`), 0, `outdoor_block_cpm_all_wo_nds`) + if(isNaN(`partner_wo_nds`), 0, `partner_wo_nds`) + if(isNaN(`outdoor_block_cover_ratio`), 0, `outdoor_block_cover_ratio`) + if(isNaN(`outdoor_block_bad_win_hits_percent`), 0, `outdoor_block_bad_win_hits_percent`) + if(isNaN(`outdoor_block_bad_win_hits`), 0, `outdoor_block_bad_win_hits`) + if(isNaN(`outdoor_partner_wo_nds`), 0, `outdoor_partner_wo_nds`) + if(isNaN(`outdoor_block_hits`), 0, `outdoor_block_hits`) + if(isNaN(`outdoor_block_cpmh_all_wo_nds`), 0, `outdoor_block_cpmh_all_wo_nds`) + if(isNaN(`outdoor_all_wo_nds`), 0, `outdoor_all_wo_nds`) + if(isNaN(`outdoor_block_winrate`), 0, `outdoor_block_winrate`) + if(isNaN(`outdoor_block_bad_shows_percent`), 0, `outdoor_block_bad_shows_percent`) + if(isNaN(`outdoor_block_direct_ctr`), 0, `outdoor_block_direct_ctr`) + if(isNaN(`all_wo_nds`), 0, `all_wo_nds`) + if(isNaN(`outdoor_block_bad_shows`), 0, `outdoor_block_bad_shows`) + if(isNaN(`outdoor_block_shows`), 0, `outdoor_block_shows`) + if(isNaN(`outdoor_block_hits_unsold`), 0, `outdoor_block_hits_unsold`) + if(isNaN(`outdoor_block_direct_clicks`), 0, `outdoor_block_direct_clicks`) + if(isNaN(`outdoor_block_bad_win_hits_own_adv`), 0, `outdoor_block_bad_win_hits_own_adv`)) > 0
) FORMAT JSONCompact

SELECT
    `_all_wo_nds` AS `all_wo_nds`,
    `_an_fraud_clicks` AS `an_fraud_clicks`,
    `_an_fraud_shows` AS `an_fraud_shows`,
    `_caption` AS `caption`,
    `_currency_id` AS `currency_id`,
    `_date` AS `date`,
    `_domain` AS `domain`,
    `_login` AS `login`,
    `_outdoor_all_wo_nds` AS `outdoor_all_wo_nds`,
    `_outdoor_block_all_hits` AS `outdoor_block_all_hits`,
    `_outdoor_block_bad_shows` AS `outdoor_block_bad_shows`,
    `_outdoor_block_bad_shows_own_adv` AS `outdoor_block_bad_shows_own_adv`,
    `_outdoor_block_bad_shows_percent` AS `outdoor_block_bad_shows_percent`,
    `_outdoor_block_bad_win_hits` AS `outdoor_block_bad_win_hits`,
    `_outdoor_block_bad_win_hits_own_adv` AS `outdoor_block_bad_win_hits_own_adv`,
    `_outdoor_block_bad_win_hits_percent` AS `outdoor_block_bad_win_hits_percent`,
    `_outdoor_block_bad_win_hits_unsold` AS `outdoor_block_bad_win_hits_unsold`,
    `_outdoor_block_cover_ratio` AS `outdoor_block_cover_ratio`,
    `_outdoor_block_cpm_all_wo_nds` AS `outdoor_block_cpm_all_wo_nds`,
    `_outdoor_block_cpm_partner_wo_nds` AS `outdoor_block_cpm_partner_wo_nds`,
    `_outdoor_block_cpmh_all_wo_nds` AS `outdoor_block_cpmh_all_wo_nds`,
    `_outdoor_block_cpmh_partner_wo_nds` AS `outdoor_block_cpmh_partner_wo_nds`,
    `_outdoor_block_direct_clicks` AS `outdoor_block_direct_clicks`,
    `_outdoor_block_direct_ctr` AS `outdoor_block_direct_ctr`,
    `_outdoor_block_direct_shows` AS `outdoor_block_direct_shows`,
    `_outdoor_block_hits` AS `outdoor_block_hits`,
    `_outdoor_block_hits_own_adv` AS `outdoor_block_hits_own_adv`,
    `_outdoor_block_hits_unsold` AS `outdoor_block_hits_unsold`,
    `_outdoor_block_shows` AS `outdoor_block_shows`,
    `_outdoor_block_shows_own_adv` AS `outdoor_block_shows_own_adv`,
    `_outdoor_block_visibility` AS `outdoor_block_visibility`,
    `_outdoor_block_winrate` AS `outdoor_block_winrate`,
    `_outdoor_partner_wo_nds` AS `outdoor_partner_wo_nds`,
    `_page_id` AS `page_id`,
    `_partner_wo_nds` AS `partner_wo_nds`
FROM (
    SELECT
        round((SUM((`all_wo_nds` / 1000)) / 10000000), 2) AS `_all_wo_nds`,
        sumIf(`an_fraud_clicks`, `product_id` = 'outdoor') AS `_an_fraud_clicks`,
        sumIf(`an_fraud_shows`, `product_id` = 'outdoor') AS `_an_fraud_shows`,
        dictGetString('pages_dict', 'caption', toUInt64(`page_id`)) AS `_caption`,
        `currency_id` AS `_currency_id`,
        `dt` AS `_date`,
        dictGetString('sources_dict', 'domain', dictGetUInt64('pages_dict', 'source_id', toUInt64(`page_id`))) AS `_domain`,
        dictGetString('users_dict', 'login', dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`))) AS `_login`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = 'outdoor_block') / 10000000), 2) AS `_outdoor_all_wo_nds`,
        sumIf(`win_max_positions_count`, `product_id` = 'outdoor_block') AS `_outdoor_block_all_hits`,
        sumIf(`bad_shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_bad_shows`,
        sumIf(`bad_shows`, (
        `dsp_id` = 5
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_bad_shows_own_adv`,
        ((sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'outdoor_block'
            )) * 100) / (sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'outdoor_block'
            )) + sumIf(`bad_shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'outdoor_block'
            )))) AS `_outdoor_block_bad_shows_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_bad_win_hits`,
        sumIf(`bad_hits`, (
        `dsp_id` = 5
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_bad_win_hits_own_adv`,
        ((sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            )) + sumIf(`bad_hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            )))) AS `_outdoor_block_bad_win_hits_percent`,
        sumIf(`bad_hits`, (
        `dsp_id` = 10
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_bad_win_hits_unsold`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'outdoor_block'
            )) * 100) / sumIf(`win_max_positions_count`, `product_id` = 'outdoor_block')) AS `_outdoor_block_cover_ratio`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'outdoor_block') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'outdoor_block'
            ))), 2) AS `_outdoor_block_cpm_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'outdoor_block') / 10000000) * 1000) / sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'outdoor_block'
            ))), 2) AS `_outdoor_block_cpm_partner_wo_nds`,
        round((((sumIf((`all_wo_nds` / 1000), `product_id` = 'outdoor_block') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            ))), 2) AS `_outdoor_block_cpmh_all_wo_nds`,
        round((((sumIf((`partner_wo_nds` / 1000), `product_id` = 'outdoor_block') / 10000000) * 1000) / sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            ))), 2) AS `_outdoor_block_cpmh_partner_wo_nds`,
        sumIf(`direct_clicks`, (
        `dsp_id` = 1
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_direct_clicks`,
        ((sumIf(`direct_clicks`, (
                `dsp_id` = 1
                AND `product_id` = 'outdoor_block'
            )) * 100) / sumIf(`direct_shows`, `product_id` = 'outdoor_block')) AS `_outdoor_block_direct_ctr`,
        sumIf(`direct_shows`, `product_id` = 'outdoor_block') AS `_outdoor_block_direct_shows`,
        sumIf(`hits`, (
        `dsp_id` NOT IN (5, 10)
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_hits`,
        sumIf(`hits`, (
        `dsp_id` = 5
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_hits_own_adv`,
        (sumIf(`win_max_positions_count`, `product_id` = 'outdoor_block') - (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'outdoor_block'
            )))) AS `_outdoor_block_hits_unsold`,
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_shows`,
        sumIf(`shows`, (
        `dsp_id` = 5
        AND `product_id` = 'outdoor_block'
    )) AS `_outdoor_block_shows_own_adv`,
        ((sumIf(`shows`, (
                `dsp_id` <> 5
                AND `product_id` = 'outdoor_block'
            )) * 100) / sumIf(`hits`, (
            `dsp_id` NOT IN (5, 10)
            AND `product_id` = 'outdoor_block'
        ))) AS `_outdoor_block_visibility`,
        ((sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            )) * 100) / (sumIf(`hits`, (
                `dsp_id` NOT IN (5, 10)
                AND `product_id` = 'outdoor_block'
            )) + sumIf(`hits`, (
                `dsp_id` = 5
                AND `product_id` = 'outdoor_block'
            )) + (sumIf(`win_max_positions_count`, `product_id` = 'outdoor_block') - (sumIf(`hits`, (
                        `dsp_id` NOT IN (5, 10)
                        AND `product_id` = 'outdoor_block'
                    )) + sumIf(`hits`, (
                        `dsp_id` = 5
                        AND `product_id` = 'outdoor_block'
                    )))))) AS `_outdoor_block_winrate`,
        round((sumIf((`partner_wo_nds` / 1000), `product_id` = 'outdoor_block') / 10000000), 2) AS `_outdoor_partner_wo_nds`,
        `page_id` AS `_page_id`,
        round((SUM((`partner_wo_nds` / 1000)) / 10000000), 2) AS `_partner_wo_nds`
    FROM `statistics`
    WHERE (
        `dt` >= '2017-08-16'
        AND `dt` <= '2017-12-31'
        AND `product_id` IN ('outdoor', 'outdoor_block')
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) IN ('id__from_table__users__with_filter__["AND",[["login","=","mock__owner-login"]]]')
        )
        AND (
            dictGetUInt64('pages_dict', 'owner_id', toUInt64(`page_id`)) IN ('id__from_table__users__with_filter__["AND",[["is_tutby","=",1]]]')
        )
        AND (
            `page_id` = 'mock__page_id'
        )
        AND (
            'outdoor.ya' = 'mock__domain'
        )
        AND (
            (`page_id`) IN (('page_id__from_table__outdoor__with_filter__["AND",[[{"json_unquote":[{"json_extract":["opts","$.caption"]}]},"=","mock__caption"]]]'))
        )
        AND (
            dictGetUInt64('pages_dict', 'multistate', toUInt64(`page_id`)) IN ('mock_multistate')
        )
        AND `currency_id` IN 'id__from_table__currencies__with_filter__["AND",[["id","IS NOT",null]]]'
    )
    GROUP BY `_caption`, `_currency_id`, `_date`, `_domain`, `_login`, `_page_id`
) `statistics`
WHERE (
    (if(isNaN(`an_fraud_clicks`), 0, `an_fraud_clicks`) + if(isNaN(`outdoor_block_direct_shows`), 0, `outdoor_block_direct_shows`) + if(isNaN(`outdoor_block_visibility`), 0, `outdoor_block_visibility`) + if(isNaN(`outdoor_block_all_hits`), 0, `outdoor_block_all_hits`) + if(isNaN(`outdoor_block_cpm_partner_wo_nds`), 0, `outdoor_block_cpm_partner_wo_nds`) + if(isNaN(`outdoor_block_cpmh_partner_wo_nds`), 0, `outdoor_block_cpmh_partner_wo_nds`) + if(isNaN(`outdoor_block_bad_win_hits_unsold`), 0, `outdoor_block_bad_win_hits_unsold`) + if(isNaN(`outdoor_block_bad_shows_own_adv`), 0, `outdoor_block_bad_shows_own_adv`) + if(isNaN(`outdoor_block_shows_own_adv`), 0, `outdoor_block_shows_own_adv`) + if(isNaN(`outdoor_block_hits_own_adv`), 0, `outdoor_block_hits_own_adv`) + if(isNaN(`outdoor_block_cpm_all_wo_nds`), 0, `outdoor_block_cpm_all_wo_nds`) + if(isNaN(`partner_wo_nds`), 0, `partner_wo_nds`) + if(isNaN(`outdoor_block_cover_ratio`), 0, `outdoor_block_cover_ratio`) + if(isNaN(`outdoor_block_bad_win_hits_percent`), 0, `outdoor_block_bad_win_hits_percent`) + if(isNaN(`outdoor_block_bad_win_hits`), 0, `outdoor_block_bad_win_hits`) + if(isNaN(`outdoor_partner_wo_nds`), 0, `outdoor_partner_wo_nds`) + if(isNaN(`outdoor_block_hits`), 0, `outdoor_block_hits`) + if(isNaN(`outdoor_block_cpmh_all_wo_nds`), 0, `outdoor_block_cpmh_all_wo_nds`) + if(isNaN(`outdoor_all_wo_nds`), 0, `outdoor_all_wo_nds`) + if(isNaN(`outdoor_block_winrate`), 0, `outdoor_block_winrate`) + if(isNaN(`outdoor_block_bad_shows_percent`), 0, `outdoor_block_bad_shows_percent`) + if(isNaN(`outdoor_block_direct_ctr`), 0, `outdoor_block_direct_ctr`) + if(isNaN(`all_wo_nds`), 0, `all_wo_nds`) + if(isNaN(`outdoor_block_bad_shows`), 0, `outdoor_block_bad_shows`) + if(isNaN(`outdoor_block_shows`), 0, `outdoor_block_shows`) + if(isNaN(`outdoor_block_hits_unsold`), 0, `outdoor_block_hits_unsold`) + if(isNaN(`an_fraud_shows`), 0, `an_fraud_shows`) + if(isNaN(`outdoor_block_direct_clicks`), 0, `outdoor_block_direct_clicks`) + if(isNaN(`outdoor_block_bad_win_hits_own_adv`), 0, `outdoor_block_bad_win_hits_own_adv`)) > 0
) FORMAT JSONCompact
