#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::Differences qw(eq_or_diff);
use Test::Partner2::Mock qw(mock_curdate);

use qbit;

use Application::Model::Statistics::_Utils::Query;

run_tests(
    sub {
        my ($app) = @_;

        mock_curdate('2019-03-20 18:11:23');

        my %opts = (
            "levels"     => [{"id" => "advnet_context_on_site_rtb", "filter" => undef}],
            "storage"    => "clickhouse",
            "only_query" => TRUE,
            "period"     => "yesterday",
        );

        my $query = $app->statistics->get_statistics(%opts, fields => ["rtb_block_shows"]);

        eq_or_diff(
            $query->get_sql_with_data(), qq[SELECT
    `_rtb_block_shows` AS `rtb_block_shows`
FROM (
    SELECT
        sumIf(`shows`, (
        `dsp_id` <> 5
        AND `product_id` = 'context_on_site_rtb'
    )) AS `_rtb_block_shows`
    FROM `statistics`
    WHERE (
        `dt` >= \'2019-03-19\'
        AND `dt` <= \'2019-03-19\'
        AND `product_id` IN ('context_on_site_rtb')
    )
) `statistics` FORMAT JSONCompact], 'SQL without groupping by currency_id', {context => 1}
        );

        $query = $app->statistics->get_statistics(%opts, fields => ["rtb_all_wo_nds"]);

        eq_or_diff(
            $query->get_sql_with_data(), qq[SELECT
    `_currency_id` AS `currency_id`,
    `_rtb_all_wo_nds` AS `rtb_all_wo_nds`
FROM (
    SELECT
        `currency_id` AS `_currency_id`,
        round((sumIf((`all_wo_nds` / 1000), `product_id` = \'context_on_site_rtb\') / 10000000), 2) AS `_rtb_all_wo_nds`
    FROM `statistics`
    WHERE (
        `dt` >= \'2019-03-19\'
        AND `dt` <= \'2019-03-19\'
        AND `product_id` IN ('context_on_site_rtb')
    )
    GROUP BY `_currency_id`
) `statistics`
WHERE (
    (if(isNaN(`rtb_all_wo_nds`), 0, `rtb_all_wo_nds`)) > 0
) FORMAT JSONCompact], 'SQL groupping by currency_id', {context => 1}
        );
    },
);
