use strict;
use warnings FATAL => 'all';

use qbit;

use Test::Partner2::Simple;
use Test::Partner::Utils qw(get_clickhouse_statistics_test_data);
use Test::More;

run_tests(
    sub {
        my ($app) = @_;

        change_cur_user($app, 'mocked-video-partner');
        my $tmp = $app->add_tmp_rights('statistics_from_ch');

        mock_ch_table(
            $app,
            {
                page_id     => 154689,
                block_id    => 2,
                dsp_id      => 1,
                currency_id => 2,
                tag_id      => 0,
            }
        );

        my $data = $app->statistics->get_statistics(
            period => ['2017-08-16', '2017-12-31'],
            fields => [
                qw(
                  video_an_site_sum_all_hits
                  instream_block_hits
                  inpage_block_visibility
                  instream_block_view
                  video_an_site_all_hits_unsold
                  )
            ],
            entity_fields => ['cation'],
            levels        => [{'id' => 'video_an_site'}],
            order_by      => [{'field' => 'date', 'dir' => 'asc'}],
            storage       => 'clickhouse',
        );
        ok($data, 'has data');
    },
    create_clickhouse_db => TRUE,
);

sub mock_ch_table {
    my ($app, $pk) = @_;

    my $data = get_clickhouse_statistics_test_data(
        $app,
        accessors => [qw(statistics_video_an_site_instream)],
        pk_data   => [map {{dt => $_, partner_wo_nds => 34203400045208, %$pk}} qw(2017-08-16 2017-08-17 2017-08-19)]
    );

    $app->clickhouse_db->statistics->add_multi($data);
}
