#/usr/bin/perl

use Test::Partner2::Simple;

use qbit;
use Test::More;
use Test::Deep qw(cmp_deeply);

run_tests(
    sub {
        my ($app) = @_;

        no strict 'refs';
        no warnings 'redefine';
        *{'QBit::Application::check_rights'} = sub {1};

        my $tree = $app->statistics->get_tree();

        is(ref($tree), 'ARRAY', 'get_tree() return array');

        cmp_ok(scalar(@$tree), '>', 0, 'get_tree() is an array with some elements');

        cmp_deeply(
            [sort keys %{$tree->[0]}],
            [
                "children", "conflict_fields", "dimension_fields", "entity_fields", "entity_filter_fields",
                "entity_filter_simple_fields", "fields", "has_product", "has_raw_stat", "id", "title",
            ],
            'Got expected keys in first element',
        );

    }
);
