use Test::Partner2::Simple;

use Test::Deep qw(cmp_deeply ignore);
use Test::Differences qw( eq_or_diff );

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my $table_dumps_dir = $app->get_option('ApplicationPath') . 't_old_test_data/statistics/2014_03_01/table_dumps';
        my $data_dir        = $app->get_option('ApplicationPath') . 't_old_test_data/statistics/2014_03_01';
        my $hands_dir       = "$data_dir/hands";

        my %currencies = (1 => 'USD', 2 => 'RUB', 3 => 'EUR',);
        $app->partner_db->get_dbh->do("INSERT INTO currencies (id, code) VALUES  (?, ?), (?, ?), (?, ?) ;",
            {}, %currencies);

        my $tree    = $app->statistics->get_tree();
        my $id_tree = build_id_statistics_tree($tree);
        eq_or_diff(
            $id_tree,
            [
                {
                    payment => [
                        {
                            advnet_on_site => [
                                {
                                    advnet_context_on_site => [
                                        {advnet_context_on_site_rtb        => []},
                                        {advnet_context_on_site_content    => []},
                                        {advnet_context_on_site_natural    => []},
                                        {advnet_context_on_site_direct     => []},
                                        {advnet_context_on_site_mcb        => []},
                                        {advnet_context_on_site_market     => []},
                                        {advnet_context_on_site_stripe     => []},
                                        {advnet_context_on_site_adblock    => []},
                                        {advnet_context_on_site_market_api => []}
                                    ]
                                },
                                {
                                    advnet_search_on_site => [
                                        {advnet_search_on_site_premium    => []},
                                        {advnet_search_on_site_direct     => []},
                                        {advnet_search_on_site_mcb        => []},
                                        {advnet_search_on_site_market     => []},
                                        {advnet_search_on_site_market_api => []}
                                    ]
                                }
                            ]
                        },
                        {mobile_app => [{mobile_app_rtb => []}]},
                        {indoor     => [{indoor_block   => []}]},
                        {outdoor    => [{outdoor_block  => []}]},
                        {
                            video_an_site => [
                                {video_an_site_instream   => []},
                                {video_an_site_inpage     => []},
                                {video_an_site_fullscreen => []}
                            ]
                        },
                        {
                            ssp => [
                                {ssp_mobile_app  => [{ssp_mobile_app_rtb  => []}]},
                                {ssp_context_rtb => [{ssp_context_rtb_rtb => []}]},
                                {ssp_video_app   => [{ssp_video_app_rtb   => []}]}
                            ]
                        }
                    ]
                },
                {additional_income      => [],},
                {mobile_mediation_block => [],},
                {
                    yandex => [
                        {
                            internal_advnet_on_site => [
                                {
                                    internal_advnet_context_on_site => [
                                        {internal_advnet_context_on_site_rtb     => []},
                                        {internal_advnet_context_on_site_content => []},
                                        {internal_advnet_context_on_site_natural => []},
                                        {internal_advnet_context_on_site_direct  => []},
                                        {internal_advnet_context_on_site_stripe  => []}
                                    ]
                                },
                                {
                                    internal_advnet_search_on_site => [
                                        {internal_advnet_search_on_site_premium => []},
                                        {internal_advnet_search_on_site_direct  => []}
                                    ]
                                }
                            ]
                        },
                        {internal_mobile_app => [{internal_mobile_app_rtb => []}]}
                    ]
                },
                {charging => [{dsp => []}]}
            ]
        );
    },
);

sub build_id_statistics_tree {
    my ($tree) = @_;

    my $id_tree = [];
    _build_id_statistics_tree($tree, $id_tree);

    return $id_tree;
}

sub _build_id_statistics_tree {
    my ($subtree, $id_tree) = @_;

    foreach my $level (@$subtree) {
        my $level_id_tree = [];
        push(@$id_tree, {$level->{'id'} => $level_id_tree});
        _build_id_statistics_tree($level->{'children'}, $level_id_tree) if exists($level->{'children'});
    }
}
