#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;
use Test::MockObject::Extends;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        _mock_app($app);

        my $report_id = $app->statistics_reports->add(
            level           => 'payment',
            use_as_widget   => 1,
            caption         => 'Test',
            description     => 'Test desc',
            query           => '[]',
            widget_settings => {show_type => 'table'}
        );

        ok($app->statistics_reports->get($report_id, fields => [qw(use_as_widget)])->{'use_as_widget'},
            'use as widget');
    },
    user   => 'mocked-yan-partner',
    locale => 'en',
);

sub _mock_app {
    my ($app) = @_;

    $app->statistics;
    $app->{'statistics'} = Test::MockObject::Extends->new($app->{'statistics'});
    $app->statistics->mock('get_available_statistics_levels',
        sub {[qw(payment advnet_context_on_site advnet_context_on_site_rtb)]});

    $app->statistics_payment;
    $app->{'statistics_payment'} = Test::MockObject::Extends->new($app->{'statistics_payment'});
    $app->statistics_payment->mock('is_available', sub {TRUE});
}
