#!/usr/bin/perl

use qbit;

use Test::Partner2::Simple;

use Test::More;
use Test::Most qw();
use Test::Deep qw(cmp_deeply ignore re);
use Test::Exception;

use Test::MockObject::Extends;

my $AVAILABLE_FIELDS = {
    'multistate_name'    => 1,
    'description'        => 1,
    'caption'            => 1,
    'owner_id'           => 1,
    'use_as_widget'      => 1,
    'actions'            => 1,
    'available_fields'   => 1,
    'editable_fields'    => 1,
    'fields_depends'     => 1,
    'id'                 => 1,
    'is_standart_report' => 1,
    'level'              => 1,
    'multistate'         => 1,
    'not_show'           => 1,
    'order'              => 1,
    'report_order'       => 1,
    'public_id'          => 1,
    'query'              => 1,
    'report_type'        => 1,
    'widget_settings'    => 1,
    'category'           => 1,
    'category_name'      => 1,
};

run_tests(
    sub {
        my ($app) = @_;

        $app->{'statistics'} = Test::MockObject::Extends->new($app->{'statistics'});
        $app->statistics->mock('get_available_statistics_levels',
            sub {[qw(payment video_an_site video_an_site_block)]});

        my @rights = qw(
          statistics_reports_view
          statistics_reports_add
          statistics_reports_edit
          statistics_reports_delete );

        my $video_partner = {
            id     => 1010,
            roles  => {20 => {}},
            rights => \@rights,
        };

        $app->set_option(cur_user => $video_partner);
        $app->{'__CURRENT_USER_RIGHTS__'} = {map {$_ => 1} @rights};

        cmp_deeply(
            $app->statistics_reports->get_add_fields,
            {
                'caption'         => 1,
                'query'           => 1,
                'report_id'       => 1,
                'description'     => 1,
                'level'           => 1,
                'use_as_widget'   => 1,
                'widget_settings' => 1,
                'report_type'     => 1,
                'stat_type'       => 1,
            },
            'get_add_fields'
        );

        cmp_deeply(
            $app->statistics_reports->get_all(
                fields   => [keys(%{$app->statistics_reports->get_model_fields})],
                order_by => [['owner_id', 1], 'order']
            ),
            [
                {
                    'not_show'           => '0',
                    'query'              => '{"query":"default_3"}',
                    'multistate_name'    => re(qr(\w)),
                    'report_id'          => undef,
                    'multistate'         => '1',
                    'caption'            => 'caption_default_3_ru',
                    'available_fields'   => $AVAILABLE_FIELDS,
                    'id'                 => 'context_report',
                    'public_id'          => 'context_report',
                    'owner_id'           => undef,
                    'editable_fields'    => {'use_as_widget' => 1},
                    'is_standart_report' => 1,
                    'description'        => undef,
                    'level'              => 'payment',
                    'actions'            => {'edit' => re(qr(\w)),},
                    'order'              => 10,
                    'use_as_widget'      => 0,
                    'fields_depends'     => {},
                    'report_type'        => 'pi',
                    'widget_settings'    => [],
                    'category'           => 25,
                    'category_bits'      => 0,
                    'category_name'      => 'General',
                    'report_order'       => 0,
                },
                {
                    'is_standart_report' => 1,
                    'not_show'           => '0',
                    'query'              => '{"query":"default_2"}',
                    'multistate_name'    => re(qr(\w)),
                    'report_id'          => undef,
                    'description'        => undef,
                    'multistate'         => '1',
                    'level'              => 'payment',
                    'caption'            => 'caption_default_2_ru',
                    'available_fields'   => $AVAILABLE_FIELDS,
                    'id'                 => 'default_2',
                    'public_id'          => 'default_2',
                    'owner_id'           => undef,
                    'editable_fields'    => {'use_as_widget' => 1},
                    'actions'            => {'edit' => re(qr(\w)),},
                    'order'              => 10,
                    'use_as_widget'      => 0,
                    'fields_depends'     => {},
                    'report_type'        => 'pi',
                    'widget_settings'    => [],
                    'category'           => 25,
                    'category_bits'      => 0,
                    'category_name'      => 'General',
                    'report_order'       => 0,
                },
                {
                    'not_show'           => '0',
                    'query'              => '{"query":"default_1"}',
                    'multistate_name'    => re(qr(\w)),
                    'report_id'          => undef,
                    'multistate'         => '1',
                    'caption'            => 'caption_default_1_ru',
                    'available_fields'   => $AVAILABLE_FIELDS,
                    'id'                 => 'default_1',
                    'public_id'          => 'default_1',
                    'owner_id'           => undef,
                    'editable_fields'    => {'use_as_widget' => 1},
                    'is_standart_report' => 1,
                    'description'        => 'desc_default_1',
                    'level'              => 'video_an_site_block',
                    'actions'            => {'edit' => re(qr(\w)),},
                    'order'              => 140,
                    'use_as_widget'      => 0,
                    'fields_depends'     => {},
                    'report_type'        => 'pi',
                    'widget_settings'    => [],
                    'category'           => 25,
                    'category_bits'      => 0,
                    'category_name'      => 'General',
                    'report_order'       => 0,
                },
            ],
            'get_all'
        );

        eval {$app->statistics_reports->do_action('default_1', 'edit', caption => 'First statistics_reports');};
        ok($@, 'Exception is throwed.');

        eval {
            $app->statistics_reports->add(
                caption => 'Second statistics_reports',
                level   => 'yandex',
                query   => '{"query":"Second query"}'
            );
        };

        ok($@, 'Exception is throwed.');
        cmp_deeply(
            ref($@) ? $@->message() : $@,
            to_json(
                [
                    {
                        messages => [
                            gettext(
                                'Got value "%s" not in array: %s',
                                'yandex', join(', ', qw(payment video_an_site video_an_site_block))
                            )
                        ],
                        name => ['level']
                    }
                ],
                pretty => TRUE
            ),
            'Exception message is correct.'
        );

        my $available_level = @{$app->statistics->get_available_statistics_levels(output => 'levels')}[0];

        my $incorrect_use_as_widget = '4';
        my $incorrect_caption       = '';
        my $incorrect_description   = 'x' x 256;
        my $incorrect_query         = '';
        eval {
            $app->statistics_reports->add(
                level           => $available_level,
                use_as_widget   => $incorrect_use_as_widget,
                caption         => $incorrect_caption,
                description     => $incorrect_description,
                query           => $incorrect_query,
                widget_settings => {show_type => 'table'}
            );
        };
        is(ref($@), 'Exception::Validator::Errors', 'Exception is throwed.');
        cmp_deeply(
            ref($@) ? $@->message() : $@,
            to_json(
                [
                    {
                        messages => [gettext('Length "%s" less than "%s"', $incorrect_caption, 1)],
                        name     => ['caption']
                    },
                    {
                        messages => [gettext('"%s" length is greater than "%d"', $incorrect_description, 255)],
                        name     => ['description']
                    },
                    {
                        messages => [gettext('Length "%s" less than "%s"', $incorrect_query, 1)],
                        name     => ['query']
                    },
                    {
                        messages => ["Boolean type expected",],
                        name     => ['use_as_widget']
                    }
                ],
                pretty => TRUE
            ),
            'Exception message is correct.'
        );

        $incorrect_caption     = 'x' x 256;
        $incorrect_description = 'x' x 256;
        $incorrect_query       = ' ' x 65_536;
        eval {
            $app->statistics_reports->add(
                level           => $available_level,
                use_as_widget   => 1,
                caption         => $incorrect_caption,
                description     => "Test description",
                query           => $incorrect_query,
                widget_settings => {show_type => 'table'}
            );
        };

        is(ref($@), 'Exception::Validator::Errors', 'Exception is throwed.');
        cmp_deeply(
            ref($@) ? $@->message() : $@,
            to_json(
                [
                    {
                        messages => [gettext('"%s" length is greater than "%d"', $incorrect_caption, 255)],
                        name     => ['caption']
                    },
                    {
                        messages => [gettext('"%s" length is greater than "%d"', $incorrect_query, 65_535)],
                        name     => ['query']
                    },
                ],
                pretty => TRUE
            ),
            'Exception message is correct.'
        );

        $app->statistics_reports->add(
            caption => 'Second statistics_reports',
            level   => 'video_an_site',
            query   => '{"query":"Second query - рус. текст"}'
        );

        cmp_deeply(
            $app->statistics_reports->get_all(
                fields   => [keys(%{$app->statistics_reports->get_model_fields})],
                order_by => [['owner_id', 0], 'order']
            ),
            [
                {
                    'not_show'           => '0',
                    'query'              => '{"query":"default_3"}',
                    'multistate_name'    => re(qr(\w)),
                    'report_id'          => undef,
                    'multistate'         => '1',
                    'caption'            => 'caption_default_3_ru',
                    'available_fields'   => $AVAILABLE_FIELDS,
                    'id'                 => 'context_report',
                    'public_id'          => 'context_report',
                    'owner_id'           => undef,
                    'editable_fields'    => {'use_as_widget' => 1},
                    'is_standart_report' => 1,
                    'description'        => undef,
                    'level'              => 'payment',
                    'actions'            => {'edit' => re(qr(\w)),},
                    'order'              => 10,
                    'use_as_widget'      => 0,
                    'fields_depends'     => {},
                    'report_type'        => 'pi',
                    'widget_settings'    => [],
                    'category'           => 25,
                    'category_bits'      => 0,
                    'category_name'      => 'General',
                    'report_order'       => 0,
                },
                {
                    'is_standart_report' => 1,
                    'not_show'           => '0',
                    'actions'            => {'edit' => re(qr(\w)),},
                    'query'              => '{"query":"default_2"}',
                    'multistate_name'    => re(qr(\w)),
                    'report_id'          => undef,
                    'description'        => undef,
                    'multistate'         => '1',
                    'level'              => 'payment',
                    'caption'            => 'caption_default_2_ru',
                    'available_fields'   => $AVAILABLE_FIELDS,
                    'id'                 => 'default_2',
                    'owner_id'           => undef,
                    'editable_fields'    => {'use_as_widget' => 1,},
                    'order'              => 10,
                    'use_as_widget'      => 0,
                    'fields_depends'     => {},
                    'public_id'          => 'default_2',
                    'report_type'        => 'pi',
                    'widget_settings'    => [],
                    'category'           => 25,
                    'category_bits'      => 0,
                    'category_name'      => 'General',
                    'report_order'       => 0,
                },
                {
                    'is_standart_report' => 1,
                    'not_show'           => '0',
                    'actions'            => {'edit' => re(qr(\w)),},
                    'query'              => '{"query":"default_1"}',
                    'multistate_name'    => re(qr(\w)),
                    'report_id'          => undef,
                    'description'        => 'desc_default_1',
                    'multistate'         => '1',
                    'level'              => 'video_an_site_block',
                    'caption'            => 'caption_default_1_ru',
                    'available_fields'   => $AVAILABLE_FIELDS,
                    'id'                 => 'default_1',
                    'owner_id'           => undef,
                    'editable_fields'    => {'use_as_widget' => 1,},
                    'order'              => 140,
                    'use_as_widget'      => 0,
                    'fields_depends'     => {},
                    'public_id'          => 'default_1',
                    'report_type'        => 'pi',
                    'widget_settings'    => [],
                    'category'           => 25,
                    'category_bits'      => 0,
                    'category_name'      => 'General',
                    'report_order'       => 0,
                },
                {
                    'is_standart_report' => 0,
                    'not_show'           => '0',
                    'actions'            => {
                        'delete' => re(qr(\w)),
                        'edit'   => re(qr(\w)),
                    },
                    'query'            => '{"query":"Second query - рус. текст"}',
                    'multistate_name'  => re(qr(\w)),
                    'report_id'        => undef,
                    'description'      => undef,
                    'multistate'       => '1',
                    'level'            => 'video_an_site',
                    'caption'          => 'Second statistics_reports',
                    'available_fields' => $AVAILABLE_FIELDS,
                    'id'               => '1',
                    'owner_id'         => '1010',
                    'editable_fields'  => {
                        'caption'         => 1,
                        'query'           => 1,
                        'description'     => 1,
                        'use_as_widget'   => 1,
                        'widget_settings' => 1,
                    },
                    'order'           => 130,
                    'use_as_widget'   => 0,
                    'fields_depends'  => {},
                    'public_id'       => '1',
                    'report_type'     => 'pi',
                    'widget_settings' => [],
                    'category'        => 25,
                    'category_bits'   => 6,
                    'category_name'   => 'General',
                    'report_order'    => 0,
                },
            ],
            'Two reports'
        );

        $app->statistics_reports->edit(
            1,
            caption => 'First statistics_reports - edit',
            query   => '{"query":"default_1 - edit"}'
        );

        cmp_deeply(
            $app->statistics_reports->get(1, fields => [qw(caption query)]),
            {
                'query'   => '{"query":"default_1 - edit"}',
                'caption' => 'First statistics_reports - edit',
            },
            'Report edit'
        );

        eval {$app->statistics_reports->edit(1, no_show => 1)};
        is(ref($@), 'Exception::Validation::BadArguments', 'Exception is throwed.');
        cmp_deeply(
            ref($@) ? $@->message() : $@,
            gettext("You cannot edit the following fields: %s", "no_show"),
            'Exception message is correct.'
        );

        my $bad_id = $app->statistics_reports->add(
            caption => 'Bad statistics_reports',
            level   => 'video_an_site',
            query   => '{"query":"ERROR"}'
        );

        cmp_deeply(
            $app->statistics_reports->get($bad_id, fields => [keys(%{$app->statistics_reports->get_model_fields})]),
            {
                'is_standart_report' => 0,
                'not_show'           => '0',
                'actions'            => {
                    'delete' => re(qr(\w)),
                    'edit'   => re(qr(\w)),
                },
                'query'            => '{"query":"ERROR"}',
                'multistate_name'  => gettext("New") . '.',
                'report_id'        => undef,
                'description'      => undef,
                'multistate'       => '1',
                'level'            => 'video_an_site',
                'caption'          => 'Bad statistics_reports',
                'order'            => '130',
                'available_fields' => $AVAILABLE_FIELDS,
                'id'               => '2',
                'owner_id'         => '1010',
                'editable_fields'  => {
                    'caption'         => 1,
                    'query'           => 1,
                    'description'     => 1,
                    'use_as_widget'   => 1,
                    'widget_settings' => 1,
                },
                'use_as_widget'   => 0,
                'fields_depends'  => {},
                'public_id'       => '2',
                'report_type'     => 'pi',
                'widget_settings' => [],
                'category'        => 25,
                'category_bits'   => 6,
                'category_name'   => 'General',
                'report_order'    => 0,
            },
            'Added bad report'
        );

        $app->statistics_reports->delete($bad_id);

        cmp_deeply(
            $app->statistics_reports->get($bad_id, fields => [keys(%{$app->statistics_reports->get_model_fields})]),
            undef, 'delete bad report');

        my $yan_partner = {
            id     => 1009,
            roles  => {9 => {}},
            rights => \@rights,
        };

        $app->set_option(cur_user => $yan_partner);
        $app->{'__CURRENT_USER_RIGHTS__'} = {map {$_ => 1} @rights};

        $app->statistics->mock('get_available_statistics_levels', sub {[qw(payment)]});

        cmp_deeply(
            $app->statistics_reports->get_all(
                fields   => [keys(%{$app->statistics_reports->get_model_fields})],
                order_by => [['owner_id', 0], 'order']
            ),
            [
                {
                    'not_show'           => '0',
                    'query'              => '{"query":"default_2"}',
                    'multistate_name'    => re(qr(\w)),
                    'report_id'          => undef,
                    'multistate'         => '1',
                    'caption'            => 'caption_default_2_ru',
                    'available_fields'   => $AVAILABLE_FIELDS,
                    'id'                 => 'default_2',
                    'owner_id'           => undef,
                    'editable_fields'    => {'use_as_widget' => 1},
                    'is_standart_report' => 1,
                    'description'        => undef,
                    'level'              => 'payment',
                    'actions'            => {'edit' => re(qw(\w))},
                    'order'              => 10,
                    'use_as_widget'      => 0,
                    'fields_depends'     => {},
                    'public_id'          => 'default_2',
                    'report_type'        => 'pi',
                    'widget_settings'    => [],
                    'category'           => 25,
                    'category_bits'      => 0,
                    'category_name'      => 'General',
                    'report_order'       => 0,
                },
                {
                    'not_show'           => '0',
                    'query'              => '{"query":"default_3"}',
                    'multistate_name'    => re(qr(\w)),
                    'report_id'          => undef,
                    'multistate'         => '1',
                    'caption'            => 'caption_default_3_ru',
                    'available_fields'   => $AVAILABLE_FIELDS,
                    'id'                 => 'context_report',
                    'public_id'          => 'context_report',
                    'owner_id'           => undef,
                    'editable_fields'    => {'use_as_widget' => 1},
                    'is_standart_report' => 1,
                    'description'        => undef,
                    'level'              => 'payment',
                    'actions'            => {'edit' => re(qr(\w)),},
                    'order'              => 10,
                    'use_as_widget'      => 0,
                    'fields_depends'     => {},
                    'report_type'        => 'pi',
                    'widget_settings'    => [],
                    'category'           => 25,
                    'category_bits'      => 0,
                    'category_name'      => 'General',
                    'report_order'       => 0,
                },
            ],
            'Report for YAN partner'
        );

        $app->statistics_reports->delete('default_2');

        cmp_deeply(
            $app->statistics_reports->get('default_2', fields => [keys(%{$app->statistics_reports->get_model_fields})]),
            undef,
            'delete default report'
        );

    },
    user   => 'mocked-video-partner',
    locale => 'en',
    init   => [qw(statistics)],
);
