#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;
use Test::MockObject::Extends;

use qbit;

my $ALL_PAYMENTS = 'all_payments';
my $REPORT_ID    = 'default_2';

run_tests(
    sub {
        my ($app) = @_;

        _mock_app($app);

        $app->partner_db->statistics_reports->add(
            {
                id         => $ALL_PAYMENTS,
                caption    => {ru => '', en => ''},
                level      => 'payment',
                query      => '{}',
                multistate => 1
            }
        );

        is($app->statistics_reports->get($ALL_PAYMENTS, fields => [qw(id)])->{'id'}, $ALL_PAYMENTS, 'Report exists');

        my @widgets = @{from_json($app->widgets->get_all()->[0]{json_widgets_settings})};
        ok((0 == grep {$ALL_PAYMENTS eq ($_->{settings}{report_id} // '')} @widgets), 'Widget not exists');

        $app->statistics_reports->delete($ALL_PAYMENTS);

        ok(!$app->statistics_reports->get($ALL_PAYMENTS, fields => [qw(id)]), 'Deleted');

        $app->statistics_reports->edit($REPORT_ID, use_as_widget => 1,);

        @widgets = @{from_json($app->widgets->get_all()->[0]{json_widgets_settings})};
        ok((1 == scalar grep {$REPORT_ID eq ($_->{settings}{report_id} // '')} @widgets), 'Widget exists');

        $app->statistics_reports->delete($REPORT_ID);
        @widgets = @{from_json($app->widgets->get_all()->[0]{json_widgets_settings})};
        ok((0 == scalar grep {$REPORT_ID eq ($_->{settings}{report_id} // '')} @widgets), 'Widget not exists');

      SKIP: {
            skip
'Waiting while frontend add summary widget. Replace right `widget_summary_view_as_default_tmp` with `widget_summary_view_as_default` in this ticket:
              https://st.yandex-team.ru/PI-8664#1492685639000', 1,;
            cmp_deeply(
                $app->widgets->get($app->get_option('cur_user', {})->{'id'}, fields => [qw(widgets_settings)])
                  ->{'widgets_settings'},
                [
                    {
                        'type'     => 'welcome',
                        'accessor' => 'widget_welcome',
                        'settings' => {'role' => 'an_partner'},
                    },
                    {
                        'type'     => 'revenue',
                        'accessor' => 'widget_revenue',
                    },
                    {
                        'type'     => 'summary',
                        'accessor' => 'widget_summary',
                    },
                ],
                "not found widget with deleted report '$REPORT_ID'"
            );
        }
    },
    user   => 'mocked-yan-partner',
    locale => 'en'
);

sub _mock_app {
    my ($app) = @_;

    $app->statistics;
    $app->{'statistics'} = Test::MockObject::Extends->new($app->{'statistics'});
    $app->statistics->mock('get_available_statistics_levels', sub {[qw(payment)]});

    $app->statistics_payment;
    $app->{'statistics_payment'} = Test::MockObject::Extends->new($app->{'statistics_payment'});
    $app->statistics_payment->mock('is_available', sub {TRUE});
}
