#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;
use Test::MockObject::Extends;

use qbit;

my $REPORT_ID = 'default_2';

run_tests(
    sub {
        my ($app) = @_;

        _mock_app($app);

        is($app->statistics_reports->get($REPORT_ID, fields => [qw(use_as_widget)])->{'use_as_widget'},
            0, "Don't use as widget");

        $app->statistics_reports->edit($REPORT_ID, use_as_widget => 1, widget_settings => {show_type => 'chart'});

        ok($app->statistics_reports->get($REPORT_ID, fields => [qw(use_as_widget)])->{'use_as_widget'},
            'use as widget');
    },
    user => 'mocked-yan-partner',
);

sub _mock_app {
    my ($app) = @_;

    $app->statistics;
    $app->{'statistics'} = Test::MockObject::Extends->new($app->{'statistics'});
    $app->statistics->mock('get_available_statistics_levels', sub {[qw(payment)]});

    $app->statistics_payment;
    $app->{'statistics_payment'} = Test::MockObject::Extends->new($app->{'statistics_payment'});
    $app->statistics_payment->mock('is_available', sub {TRUE});
}
