SELECT
    `indoor`.`blocks_count` AS `blocks_count`,
    `indoor`.`blocks_limit` AS `blocks_limit`,
    `indoor`.`opts` -> '$.business_oid' AS `business_oid`,
    `indoor`.`create_date` AS `create_date`,
    `indoor`.`creator_id` AS `creator_id`,
    'indoor.ya' AS `domain`,
    `indoor`.`opts` -> '$.facility_type' AS `facility_type`,
    `indoor`.`opts` -> '$.gps' AS `gps`,
    `indoor`.`id` AS `id`,
    `indoor`.`multistate` AS `multistate`,
    `indoor`.`opts` AS `opts`,
    `indoor`.`owner_id` AS `owner_id`,
    `indoor`.`page_id` AS `page_id`,
    'indoor' AS `product_type`,
    `indoor`.`id` AS `public_id`,
    `indoor`.`send_time` AS `send_time`,
    `indoor`.`tier` AS `tier`,
    `indoor`.`update_time` AS `update_time`,
    `indoor`.`waiting_moderation` AS `waiting_moderation`
FROM `indoor`
WHERE (
    `indoor`.`owner_id` = '1018'
    OR `indoor`.`page_id` = ANY (
        SELECT
            `assistants`.`page_id` AS `page_id`
        FROM `assistants`
        WHERE (
            `assistants`.`dissabled` = '0'
            AND `assistants`.`user_id` = '1018'
        )
    )
)
