SELECT
    `statistics_reports`.`caption_ru` AS `caption`,
    `statistics_reports`.`category_bits` AS `category_bits`,
    `statistics_reports`.`description` AS `description`,
    `statistics_reports`.`id` AS `id`,
    `statistics_reports`.`level` AS `level`,
    `statistics_reports`.`multistate` AS `multistate`,
    `statistics_reports`.`not_show` AS `not_show`,
    `a_statistics_reports_level_order`.`order` AS `order`,
    `statistics_reports`.`owner_id` AS `owner_id`,
    `statistics_reports`.`query` AS `query`,
    `statistics_reports`.`report_id` AS `report_id`,
    `statistics_reports`.`report_order` AS `report_order`,
    `statistics_reports`.`report_type` AS `report_type`
FROM `statistics_reports`
INNER JOIN `statistics_reports_level_order` AS `a_statistics_reports_level_order` ON (
    `a_statistics_reports_level_order`.`level_id` = `statistics_reports`.`level`
)
WHERE (
    `statistics_reports`.`multistate` IN ('0', '1', '2', '3')
    AND `statistics_reports`.`level` IN ('advnet_context_on_site', 'advnet_context_on_site_adblock', 'advnet_context_on_site_content', 'advnet_context_on_site_direct', 'advnet_context_on_site_market', 'advnet_context_on_site_market_api', 'advnet_context_on_site_mcb', 'advnet_context_on_site_natural', 'advnet_context_on_site_rtb', 'advnet_context_on_site_stripe', 'advnet_on_site', 'advnet_search_on_site', 'advnet_search_on_site_direct', 'advnet_search_on_site_market', 'advnet_search_on_site_market_api', 'advnet_search_on_site_mcb', 'advnet_search_on_site_premium', 'indoor', 'indoor_block', 'mobile_app', 'mobile_app_rtb', 'mobile_mediation_block', 'outdoor', 'outdoor_block', 'payment', 'ssp', 'ssp_context_rtb', 'ssp_context_rtb_rtb', 'ssp_mobile_app', 'ssp_mobile_app_rtb', 'video_an_site', 'video_an_site_fullscreen', 'video_an_site_inpage', 'video_an_site_instream')
    AND (
        `statistics_reports`.`owner_id` = '1015'
        OR isnull(`statistics_reports`.`owner_id`)
    )
    AND `statistics_reports`.`report_type` = 'pi'
)
ORDER BY `order`, `report_order`
