SELECT
    `statistics_reports`.`caption_ru` AS `caption`,
    `statistics_reports`.`category_bits` AS `category_bits`,
    `statistics_reports`.`description` AS `description`,
    `statistics_reports`.`id` AS `id`,
    `statistics_reports`.`level` AS `level`,
    `statistics_reports`.`multistate` AS `multistate`,
    `statistics_reports`.`not_show` AS `not_show`,
    `a_statistics_reports_level_order`.`order` AS `order`,
    `statistics_reports`.`owner_id` AS `owner_id`,
    `statistics_reports`.`query` AS `query`,
    `statistics_reports`.`report_id` AS `report_id`,
    `statistics_reports`.`report_order` AS `report_order`,
    `statistics_reports`.`report_type` AS `report_type`
FROM `statistics_reports`
INNER JOIN `statistics_reports_level_order` AS `a_statistics_reports_level_order` ON (
    `a_statistics_reports_level_order`.`level_id` = `statistics_reports`.`level`
)
WHERE (
    `statistics_reports`.`multistate` IN ('0', '1', '2', '3')
    AND NULL
    AND (
        `statistics_reports`.`owner_id` = '88415289'
        OR isnull(`statistics_reports`.`owner_id`)
    )
    AND `statistics_reports`.`report_type` = 'pi'
)
ORDER BY `order`, `report_order`
