#!/usr/bin/perl

use Test::Differences qw(eq_or_diff);

use qbit;

use Test::Partner::Utils qw(get_test_data_and_update_if_needed);
use Test::Partner2::Mock qw(mock_subs restore_subs);
use Test::Partner2::Simple;

my @METHODS = (map {("daily_$_", "monthly_$_")} qw(dsp));

run_tests(
    sub {
        my ($app) = @_;

        my @products;
        mock_subs(
            {
                'Cron::Methods::_regular_update_statistics' => sub {
                    my ($self, %opts) = @_;

                    foreach my $product (@{$opts{products} // []}) {
                        push @products,
                          {
                            product     => $product,
                            periodicity => ($opts{for_month} ? 'monthly' : 'daily'),
                            storage => ($opts{storage} // 'mysql'),
                          };
                    }
                },
            }
        );

        $app->do('update_stats', $_) foreach @METHODS;

        @products = sort {$a->{product} cmp $b->{product} or $a->{periodicity} cmp $b->{periodicity}} @products;
        my $expected = get_test_data_and_update_if_needed('products.json', \@products);
        eq_or_diff(\@products, $expected, 'checks');
    },
    application_package  => 'Cron',
    do_not_die_on_fail   => 1,
    dont_create_database => 1,
);
