#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Most;
use Test::Partner2::Simple;
use Test::Partner::Utils;

my $PATH_NAME   = 'webmaster';
my $METHOD_NAME = 'get_turbo_v2';

my $tests = [
    {
        name         => 'Block not found is ok',
        query_string => 'page_id=414&block_id=1',
        data         => q[Status: 200 OK
X-Content-Type-Options: nosniff
Content-Type: application/json; charset=UTF-8

{"data":{"error":"block not found"},"result":"ok"}]
    },
    {
        name         => 'Turbo off is ok',
        query_string => 'page_id=41443&block_id=1',
        data         => q[Status: 200 OK
X-Content-Type-Options: nosniff
Content-Type: application/json; charset=UTF-8

{"data":{"page_id":"41443","block_id":"1","site_version":"desktop","direct_format":"horizontal","media_size":"970x90"},"result":"ok"}]
    },
    {
        name         => 'Turbo on is ok',
        query_string => 'page_id=142898&block_id=1',
        data         => q[Status: 200 OK
X-Content-Type-Options: nosniff
Content-Type: application/json; charset=UTF-8

{"data":{"page_id":"142898","block_id":"1","site_version":"turbo","direct_format":"horizontal","media_size":"970x90"},"result":"ok"}]
    },
    {
        name         => 'Turbo off is ok (internal RTB)',
        query_string => 'page_id=88848&block_id=1',
        data         => q[Status: 200 OK
X-Content-Type-Options: nosniff
Content-Type: application/json; charset=UTF-8

{"data":{"page_id":"88848","block_id":"1","site_version":"desktop","direct_format":"horizontal","media_size":"320x50"},"result":"ok"}]
    },
    {
        name         => 'Turbo on is ok (internal RTB)',
        query_string => 'page_id=88848&block_id=2',
        data         => q[Status: 200 OK
X-Content-Type-Options: nosniff
Content-Type: application/json; charset=UTF-8

{"data":{"page_id":"88848","block_id":"2","site_version":"turbo","direct_format":"horizontal","media_size":"320x50"},"result":"ok"}]
    }
];

run_tests(
    sub {
        my ($app) = @_;

        foreach my $test (@$tests) {
            my ($header, $out) = request_to_intapi(
                app          => $app,
                path         => $PATH_NAME,
                method       => $METHOD_NAME,
                query_string => $test->{query_string},
                mode         => 'only_stdout',
            );

            cmp_deeply("$header\n\n$out", $test->{data}, $test->{name});
        }
    },
    application_package => 'IntAPI',
    init                => [qw(intapi_acl)],
);
