#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Most;
use Test::Partner2::Simple;
use Test::Deep;

use Test::Partner2::Utils qw(check_fields);

use qbit;

my $PATH_NAME   = 'yavideo';
my $METHOD_NAME = 'get_pages_for_ya_video';

run_tests(
    sub {
        my ($app) = @_;

        my $methods = $app->get_methods();

        my $api = $methods->{$PATH_NAME}{$METHOD_NAME}{'package'}->new(
            app   => $app,
            path  => $PATH_NAME,
            attrs => $methods->{$PATH_NAME}{$METHOD_NAME}->{'attrs'}
        );

        my $data = $methods->{$PATH_NAME}{$METHOD_NAME}{'sub'}->($api);

        ok(@$data, 'not empty response');

        cmp_deeply(
            $data,
            [
                {
                    'hosts'   => ['newsru.com', 'approvedmirror.ru'],
                    'caption' => 'Test video site',
                    'page_id' => '154689',
                    'pixels'  => [
                        {
                            'pixel_type' => 'open_player',
                            'url' =>
'http://pixel2.com?count=12&page_id=154689&pixel_type=open_player&position_id=%position_id%&request=%request%&host=%host%&url=%url%',
                            'position_type' => 'commercial'
                        },
                        {
                            'pixel_type' => 'view',
                            'url' =>
'http://pixel2.com/count?count=23&view=32&page_id=154689&pixel_type=view&position_id=%position_id%&request=%request%&host=%host%&url=%url%',
                            'position_type' => 'commercial'
                        },
                        {
                            'pixel_type' => 'open_player',
                            'url' =>
'http://pixel1.com/?page_id=154689&pixel_type=open_player&position_id=%position_id%&request=%request%&host=%host%&url=%url%',
                            'position_type' => 'organic'
                        },
                        {
                            'pixel_type' => 'view',
                            'url' =>
'http://pixel1.com/count?page_id=154689&pixel_type=view&position_id=%position_id%&request=%request%&host=%host%&url=%url%',
                            'position_type' => 'organic'
                        }
                    ],
                    'partner_type' => 'kp+rsya'
                }
            ],
            'check structure response'
        );
    },
    application_package => 'IntAPI'
);
