use qbit;

use Test::More;
use Test::MockObject;
use File::Temp qw(tempfile tempdir);

use Test::Partner2::Simple;
use Test::Partner2::Mock;
use Test::Partner::Utils;    # qw(get_test_data_and_update_if_needed);
use Test::Differences;

use PiVariables qw(
  FROM_DATE_CLICKHOUSE_BILLING_DATA
  );

run_tests(
    sub {
        my ($app) = @_;

        my $date = '2020-09-17';
        $PiVariables::FROM_DATE_CLICKHOUSE_BILLING_DATA = $date;
        mock_curdate($date . ' 15:00:00');
        mock_api_balance($app);
        fill_clickhouse($app);

        my @tests = (
            {
                title         => 'without_money',
                without_money => TRUE,
            },
            {
                title       => 'get_tsv_fh',
                _get_tsv_fh => TRUE,
            },
            {
                title => 'model',
                model => $app->context_on_site_rtb
            },
            {
                title       => 'block_model',
                block_model => 'context_on_site_rtb',
            },
        );

        for my $test (@tests) {
            my $title = delete $test->{title};
            my $has   = $app->api_balance->get_dsp_stat(
                from => $date,
                to   => $date,
                %$test
            );
            my $ext = '.json';
            my %opts;
            if ($test->{_get_tsv_fh}) {
                $has       = fh_to_data($has);
                $ext       = '.dump';
                $opts{raw} = TRUE;
            }
            my $expected = get_test_data_and_update_if_needed($title . $ext, $has, %opts);
            eq_or_diff($has, $expected, 'check ' . $title);
        }
    },
    create_clickhouse_db => TRUE,
);

sub fh_to_data {
    my ($fh) = @_;

    local $/;
    my $data = <$fh>;
    close $fh;

    return $data;
}

sub mock_api_balance {
    my ($app) = @_;

    $app->api_balance;
    $app->{'api_balance'} = Test::MockObject::Extends->new($app->{'api_balance'});

    $app->api_balance->mock(
        _get_cache_file_path => sub {
            my ($self, $method, %params) = @_;
            if ($method eq 'Balance2.GetDspStat') {
                my $p = $params{include_partner_stat_id} ? '_ips' : '';
                return get_test_data_path() . "/cache$p.tsv";
            } else {
                die "unsupported method '$method'\n";
            }
        },
    );
    $app->api_balance->mock(
        _check_cache_file => sub {
            my ($self, $file) = @_;
            return 1;
        },
    );
}

sub fill_clickhouse {
    my ($app) = @_;

    my $data = get_test_data_and_update_if_needed('balance_statistics.json');
    $app->clickhouse_db->balance_statistics->add_multi($data);

    $data = get_test_data_and_update_if_needed('pages_dict_table.json');
    $app->clickhouse_db->pages_dict_table->add_multi($data);

    $data = get_test_data_and_update_if_needed('blocks_dict_table.json');
    $app->clickhouse_db->blocks_dict_table->add_multi($data);
}
