use qbit;

use Test::More;
use Test::MockObject;
use File::Temp qw(tempfile tempdir);

use Test::Partner2::Simple;
use Test::Partner2::Mock;
use Test::Partner::Utils;
use Test::Differences;

use Cwd qw(abs_path);

use PiVariables qw(
  FROM_DATE_CLICKHOUSE_BILLING_DATA
  );

run_tests(
    sub {
        my ($app) = @_;

        my $date = '2020-09-17';
        $PiVariables::FROM_DATE_CLICKHOUSE_BILLING_DATA = $date;
        mock_curdate($date . ' 15:00:00');
        mock_api_balance($app);
        fill_clickhouse($app);

        my @tests = (
            {
                title       => 'only_place_context_direct',
                only_place  => $app->statistics_internal_advnet_context_on_site_direct->_get_pages_stat_places(),
                block_model => 'internal_context_on_site_direct',
            },
            {
                title => 'only_place_search_direct',
                only_place =>
                  $app->statistics_internal_advnet_search_on_site_direct->_get_pages_stat_places(with_type => TRUE),
                block_model => 'internal_search_on_site_direct',
            },
            {
                title => 'only_place_premium',
                only_place =>
                  $app->statistics_internal_advnet_search_on_site_premium->_get_pages_stat_places(with_type => TRUE),
                block_model => 'internal_search_on_site_premium',
            },
        );

        for my $test (@tests) {
            my $title = delete $test->{title};
            my $has   = $app->api_balance->get_internal_pages_tags_stat(
                from => $date,
                to   => $date,
                %$test
            );
            my $ext = '.json';
            my $expected = get_test_data_and_update_if_needed($title . $ext, $has);
            eq_or_diff($has, $expected, 'check ' . $title);
        }
    },
    create_clickhouse_db => TRUE,
);

sub mock_api_balance {
    my ($app) = @_;

    $app->api_balance;
    $app->{'api_balance'} = Test::MockObject::Extends->new($app->{'api_balance'});

    $app->api_balance->mock(
        _get_cache_file_path => sub {
            my ($self, $method, %params) = @_;
            if ($method eq 'Balance2.GetInternalPagesTagsStat') {
                return get_test_data_path() . "/cache.tsv";
            } else {
                die "unsupported method '$method'\n";
            }
        },
    );
    $app->api_balance->mock(
        _check_cache_file => sub {
            my ($self, $file) = @_;
            return 1;
        },
    );
}

sub fill_clickhouse {
    my ($app) = @_;

    my $data = get_test_data_and_update_if_needed('balance_statistics.json');
    $app->clickhouse_db->balance_statistics->add_multi($data);

    $data = get_test_data_and_update_if_needed('pages_dict_table.json');
    $app->clickhouse_db->pages_dict_table->add_multi($data);

    $data = get_test_data_and_update_if_needed('blocks_dict_table.json');
    $app->clickhouse_db->blocks_dict_table->add_multi($data);
}
