use qbit;

use Test::More;
use Test::MockObject;
use File::Temp qw(tempfile tempdir);

use Test::Partner2::Simple;
use Test::Partner2::Mock;
use Test::Partner::Utils;    # qw(get_test_data_and_update_if_needed);
use Test::Differences;

use PiVariables qw(
  FROM_DATE_CLICKHOUSE_BILLING_DATA
  );

run_tests(
    sub {
        my ($app) = @_;

        my $date = '2020-09-17';
        my %opts;
        $PiVariables::FROM_DATE_CLICKHOUSE_BILLING_DATA = $date;
        mock_curdate($date . ' 15:00:00');
        mock_api_balance($app);
        fill_clickhouse($app);

        my @tests = (
            {
                title => 'search_direct',
                model => 'statistics_advnet_search_on_site_direct',
            },
            {
                title => 'search_premium',
                model => 'statistics_advnet_search_on_site_premium',
            },
        );

        for my $test (@tests) {
            my $title = delete $test->{title};
            my $model = delete $test->{model};
            my $has   = $app->$model->update_statistics(    #_get_stat_from_balance(
                from => $date,
                to   => $date,
                %$test
            );
            my $ext = '.json';
            $has = $app->clickhouse_db->statistics->get_all(fields => [qw(page_id block_id product_id partner_wo_nds)]);
            my $expected = get_test_data_and_update_if_needed($title . $ext, $has, %opts);
            eq_or_diff($has, $expected, 'check ' . $title);
        }
    },
    create_clickhouse_db => TRUE,
);

sub fh_to_data {
    my ($fh) = @_;

    local $/;
    my $data = <$fh>;
    close $fh;

    return $data;
}

sub mock_api_balance {
    my ($app) = @_;

    $app->api_balance;
    $app->{'api_balance'} = Test::MockObject::Extends->new($app->{'api_balance'});

    $app->api_balance->mock(
        _get_cache_file_path => sub {
            my ($self, $method, %params) = @_;
            if ($method eq 'Balance.GetPagesStat') {
                return get_test_data_path() . "/get_pages_stat.tsv";
            } elsif ($method eq 'Balance2.GetPagesTagsStat') {
                return get_test_data_path() . "/get_pages_tags_stat.tsv";
            } else {
                die "unsupported method '$method'\n";
            }
        },
    );
    $app->api_balance->mock(
        _check_cache_file => sub {
            my ($self, $file) = @_;
            return 1;
        },
    );
}

sub fill_clickhouse {
    my ($app) = @_;

    my $data = get_test_data_and_update_if_needed('balance_statistics.json');
    $app->clickhouse_db->balance_statistics->add_multi($data);

    $data = get_test_data_and_update_if_needed('pages_dict_table.json');
    $app->clickhouse_db->pages_dict_table->add_multi($data);

    $data = get_test_data_and_update_if_needed('blocks_dict_table.json');
    $app->clickhouse_db->blocks_dict_table->add_multi($data);
}
