use strict;
use warnings FATAL => 'all';

use qbit;

use Test::Partner::Utils qw(get_test_data_and_update_if_needed get_test_data_path);
use Test::Partner2::Simple;
use Test::Partner2::Mock qw(mock_utils_partner2);

use Test::More;
use Test::Deep;

run_tests(
    sub {
        my ($app) = @_;

        mock_utils_partner2($app);

        my $login    = 'mocked-indoor-partner';
        my $articles = [
            'СРЕДСТВА СВЯЗИ И ОБОРУДОВАНИЕ',
            'АУДИО, ВИДЕО, КИНО И ФОТОТЕХНИКА'
        ];
        my $brands = ['SAMSUNG', 'COCA-COLA-PEPSI'];
        my $blocks = from_json(readfile(get_test_data_path() . '/in_blocks.json'));

        my ($blocks_added, $errors) = $app->indoor_block->add_blocks($login, $articles, $brands, $blocks);

        for (my $i = 0; $i < @$blocks_added; $i++) {
            unless ($blocks_added->[$i]->{page_id} && $blocks_added->[$i]->{block_id}) {
                isnt($errors->[$i], '', 'error is not empty if there is no page_id & block_id');
            }
        }

        compare_data('non empty blocks array', $blocks_added);
        compare_data('non empty errors array', $errors);

        my $page_list = $app->indoor->get_all(
            filter => [page_id => 'IN' => array_uniq([map {$_->{page_id}} grep {$_->{page_id}} @$blocks_added])],
            fields   => [qw(owner_id page_id caption facility_type address gps business_oid)],
            order_by => [['page_id', 1]]
        );

        compare_data('pages_created', $page_list);

        my $block_list = $app->indoor_block->get_all(
            filter => [page_id => 'IN' => array_uniq([map {$_->{page_id}} grep {$_->{page_id}} @$blocks_added])],
            fields => [
                qw(page_id id public_id caption comment zone_category aspect_ratio resolution min_duration max_duration sound touch_screen strategy mincpm brands articles photo_id_list)
            ],
            order_by => [['page_id', 1], ['id', 0]]
        );

        compare_data('blocks created', $block_list);
    },
    do_not_die_on_fail => 1,
);

sub compare_data {
    my ($check, $got_data, $cmp_sub) = @_;

    $cmp_sub //= \&cmp_deeply;

    (my $filename = $check) =~ s/\s/_/g;
    my $json_data = get_test_data_and_update_if_needed("$filename.json", $got_data);

    $cmp_sub->($got_data, $json_data, "checking: $check");
}
