use strict;
use warnings FATAL => 'all';

use qbit;

use Utils::CSV;

use Test::Differences qw(eq_or_diff);
use Test::More;
use Test::Partner::Utils qw(get_test_data_and_update_if_needed get_test_data_path);

my $in  = from_json(readfile(get_test_data_path() . '/in_data.json'));
my $got = combine_csv_indoor_blocks($in);

my $expected = get_test_data_and_update_if_needed("combined.csv", $got, raw => 1);
eq_or_diff($got, $expected, "checking combined");

test_write_xslx($in);

sub test_write_xslx {
    my ($parsed) = @_;

    my $SEP_IN_FIELD         = ',';
    my @indoor_block_headers = qw( _ page_id block_id page_caption page_gps page_address page_oname _ facility_type
      block_caption _ zone_category block_reso_width block_reso_height block_aspect_ratio block_min_duration block_max_duration
      block_sound block_touch block_mincpm block_photos block_comment);

    require Spreadsheet::WriteExcel;

    #open my $XLS, '>', \my $text;
    my $filename = get_test_data_path() . '/test.0.xls';

    my $workbook  = Spreadsheet::WriteExcel->new($filename);
    my $worksheet = $workbook->add_worksheet();
    my ($col, $row);
    $col = $row = 0;

    my @b = map {
        my %t = %{$_};
        $t{block_photos} = join($SEP_IN_FIELD, @{$_->{block_photos}});
        $t{block_sound} = '1' eq $_->{block_sound} ? 'Y' : 'N';
        $t{block_touch} = '1' eq $_->{block_touch} ? 'Y' : 'N';
        [@t{@indoor_block_headers}]
    } @{$parsed->{blocks}};

    foreach my $line (
        ['login', $parsed->{login}],
        [''], ['articles', join($SEP_IN_FIELD, @{$parsed->{articles}})],
        [''], ['brands',   join($SEP_IN_FIELD, @{$parsed->{brands}})],
        [''], $parsed->{headers}, @b
      )
    {
        foreach my $element (@$line) {
            $worksheet->write($row, $col, $element);
            $col++;
        }
        $col = 0;
        $row++;
    }

    $workbook->close();

    return $filename;
}

done_testing();
