#!/usr/bin/perl -w

use FindBin qw($Bin);

use lib "$Bin/lib";

use qbit;
use Partner::DB qw(get_db_partner2);
use Partner::AlterDB;
use Getopt::Long;

my $compare_with_production_db = FALSE;
GetOptions('prod' => \$compare_with_production_db,) || help();
my $alter_db = Partner::AlterDB->new(compare_with_production_db => $compare_with_production_db);

print "\n# Tables dropping.\n";
print $alter_db->get_drop_table_sql();

print "\n# Tables creation.\n";
print $alter_db->get_create_table_sql();

print "\n# Tables altering.\n";
my $alter_sql_for_table = $alter_db->get_alter_table_sql();
while (my ($table, $alter_table_sql) = each %$alter_sql_for_table) {
    print "# $table\n";
    print $alter_table_sql;
}
print "\n";

exit;

sub help {
    print <<HELP;
    $0 generates sql to synchronise PI code with database.

    Options:
        --prod  Compare with production database. By defaults it compares with test one.

HELP

    exit;
}
