package Exception::Partner::AlterDB;
use base qw(Exception);

package Partner::AlterDB;
use base qw(QBit::Class);

use strict;
use warnings FATAL => 'all';

use qbit;
use Partner::DB qw(get_db_partner2);
use Partner::AlterDB::Table;

sub init {
    my ($self) = @_;

    $self->{description_from_code_for} = do {
        local $/ = '';

        (my $package_name = __PACKAGE__) =~ s'::'/';
        (my $beta_root_dir = $INC{$package_name . '.pm'}) =~ s"(/beta\.\d{4})/.*"$1";

        my @code_table_descriptions = qx(cd $beta_root_dir; make partner_db_create_sql_show;);
        @code_table_descriptions || die "No table descriptions from code are gotten.";
        my %description_from_code_for;
        foreach my $description (@code_table_descriptions) {
            my ($table) = ($description =~ /CREATE TABLE `(\S+)`/);
            $description_from_code_for{$table} = $description;
        }
        \%description_from_code_for;
    };
    $self->{db_partner2} = get_db_partner2(server => ($self->{compare_with_production_db} ? 'prod' : 'test'));
    $self->{description_from_db_for} = do {
        my @tables = map {$_->{'Tables_in_partner'}} @{$self->{db_partner2}->get_data("SHOW TABLES")};
        my %description_from_db_for;
        foreach my $table (@tables) {
            $description_from_db_for{$table} = $self->get_table_description_from_db($table);
        }
        \%description_from_db_for;
    };
}

sub get_table_description_from_db {
    my ($self, $table) = @_;
    return $self->clean_sql(@{$self->{db_partner2}->get_data("SHOW CREATE TABLE $table")}[0]->{'Create Table'});
}

sub get_drop_table_sql {
    my ($self) = @_;

    my $sql = '';
    foreach my $table (
        @{arrays_difference([keys %{$self->{description_from_db_for}}], [keys %{$self->{description_from_code_for}}])})
    {
        $sql .= "DROP TABLE $table;\n";
    }

    return $sql;
}

sub get_create_table_sql {
    my ($self) = @_;

    my $sql = '';
    foreach my $table (
        @{arrays_difference([keys %{$self->{description_from_code_for}}], [keys %{$self->{description_from_db_for}}])})
    {
        $sql .= $self->{description_from_code_for}{$table};
    }

    return $sql;
}

sub get_alter_table_sql {
    my ($self) = @_;

    my %sql_for_table;
    $self->{db_partner2}->execute("DROP TABLE IF EXISTS `to_drop`");
    foreach my $table (keys %{$self->{description_from_code_for}}) {
        if (exists($self->{description_from_db_for}{$table})) {
            my $temporary_table_description = $self->{description_from_code_for}{$table};
            my $temporary_table             = 'to_drop';
            $temporary_table_description =~ s/$table/$temporary_table/g;

            $temporary_table_description =~ s/(BOOLEAN NOT NULL DEFAULT) ''/$1 0/g;

            $self->{db_partner2}->execute($temporary_table_description);
            my $description_from_code = $self->get_table_description_from_db($temporary_table);
            $self->{db_partner2}->execute("DROP TABLE IF EXISTS `$temporary_table`");

            $description_from_code =~ s/$temporary_table/$table/g;

            my $alter_table = Partner::AlterDB::Table->new(table => $table);
            my $sql_alter_query =
              $alter_table->get_sql_alter_query($self->{description_from_db_for}{$table}, $description_from_code);
            $sql_for_table{$table} = $sql_alter_query if $sql_alter_query;
        }
    }

    return \%sql_for_table;
}

sub clean_sql {
    my ($self, $sql) = @_;

    $sql =~ s/ AUTO_INCREMENT=\d+//;
    return $sql;
}

TRUE;
