package Exception::Partner::AlterDB::Table::Comparator;
use base qw(Exception::Partner::AlterDB::Table);

package Partner::AlterDB::Table::Comparator;
use base qw(QBit::Class);

use strict;
use warnings FATAL => 'all';

use qbit;

sub init {
    my ($self) = @_;

    throw Exception::Partner::AlterDB::Table::Comparator 'etalon option must be gotten'
      unless exists $self->{'etalon'};
    throw Exception::Partner::AlterDB::Table::Comparator 'copy option must be gotten'
      unless exists $self->{'copy'};

    $self->SUPER::init();

    $self->{'description_etalon'} = [split(qr{,?\n}, $self->{'etalon'})];
    $self->{'description_copy'}   = [split(qr{,?\n}, $self->{'copy'})];

    my %columns_to_drop;
    $self->{'strings_to_drop'} = [];
    foreach my $string (@{arrays_difference($self->{'description_copy'}, $self->{'description_etalon'})}) {
        if (my ($column) = $string =~ /^\s*`(\S+)`/) {
            $columns_to_drop{$column} = $string;
        } else {
            push @{$self->{'strings_to_drop'}}, $string;
        }
    }
    my %columns_to_create;
    $self->{'strings_to_create'} = [];
    foreach my $string (@{arrays_difference($self->{'description_etalon'}, $self->{'description_copy'})}) {
        if (my ($column) = $string =~ /^\s*`(\S+)`/) {
            $columns_to_create{$column} = $string;
        } else {
            push @{$self->{'strings_to_create'}}, $string;
        }
    }
    my %columns_to_modify;
    foreach my $column (@{arrays_intersection([keys %columns_to_drop], [keys %columns_to_create])}) {
        $columns_to_modify{$column} = $columns_to_create{$column};
        delete $columns_to_drop{$column};
        delete $columns_to_create{$column};
    }

    $self->{'columns_to_drop'}   = [values %columns_to_drop];
    $self->{'columns_to_modify'} = [values %columns_to_modify];
    $self->{'columns_to_create'} = [values %columns_to_create];

    return $self;
}

sub get_etalon_strings    {return @{$_[0]->{'description_etalon'}};}
sub get_copy_strings      {return @{$_[0]->{'description_copy'}};}
sub get_strings_to_drop   {return @{$_[0]->{'strings_to_drop'}};}
sub get_strings_to_create {return @{$_[0]->{'strings_to_create'}};}
sub get_columns_to_drop   {return @{$_[0]->{'columns_to_drop'}};}
sub get_columns_to_modify {return @{$_[0]->{'columns_to_modify'}};}
sub get_columns_to_create {return @{$_[0]->{'columns_to_create'}};}

TRUE;
