#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use qbit;

use Test::More;
use FindBin qw($Bin);

use lib "$Bin/../lib/";
use Partner::AlterDB::Table;

{
    my $table                         = 'internal_context_on_site_campaign';
    my $description_with_many_columns = "CREATE TABLE `$table` (
        `id` int(10) unsigned NOT NULL,
        `create_date` datetime NOT NULL,
        `domain` varchar(1024) NOT NULL,
        `family_filter` tinyint(1) NOT NULL,
        `behavioral_targeting` tinyint(1) NOT NULL,
        `view_images` tinyint(1) NOT NULL,
        `settings_articles` tinyint(1) NOT NULL,
        `multistate` bigint(20) unsigned NOT NULL DEFAULT '0',
        `articles` mediumtext,
        `brands` mediumtext,
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8"
      ;
    my $description_with_few_columns = "CREATE TABLE `$table` (
        `id` int(10) unsigned NOT NULL,
        `create_date` datetime NOT NULL,
        `domain` varchar(1024) NOT NULL,
        `multistate` bigint(20) unsigned NOT NULL DEFAULT '0',
        PRIMARY KEY (`id`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8"
      ;

    {
        my $alter_table = Partner::AlterDB::Table->new(table => $table);
        my $alter_query =
          $alter_table->get_sql_alter_query($description_with_many_columns, $description_with_few_columns,);
        is(
            $alter_query,
            "ALTER TABLE `$table` DROP `articles`;\n"
              . "ALTER TABLE `$table` DROP `behavioral_targeting`;\n"
              . "ALTER TABLE `$table` DROP `brands`;\n"
              . "ALTER TABLE `$table` DROP `family_filter`;\n"
              . "ALTER TABLE `$table` DROP `settings_articles`;\n"
              . "ALTER TABLE `$table` DROP `view_images`;\n",
            'Excess columns.'
          );
    }
    {
        my $alter_table = Partner::AlterDB::Table->new(table => $table);
        my $alter_query =
          $alter_table->get_sql_alter_query($description_with_few_columns, $description_with_many_columns,);
        is(
            $alter_query,
            "ALTER TABLE `$table` ADD `articles` mediumtext;\n"
              . "ALTER TABLE `$table` ADD `behavioral_targeting` tinyint(1) NOT NULL;\n"
              . "ALTER TABLE `$table` ADD `brands` mediumtext;\n"
              . "ALTER TABLE `$table` ADD `family_filter` tinyint(1) NOT NULL;\n"
              . "ALTER TABLE `$table` ADD `settings_articles` tinyint(1) NOT NULL;\n"
              . "ALTER TABLE `$table` ADD `view_images` tinyint(1) NOT NULL;\n",
            'Forgotten columns.'
          );
    }
}

done_testing();
