#!/bin/bash

if [ -z "$1" ]; then
  echo check_nodejs_version.sh args: $*
  echo Usage: $0 minMajorVersion [maxMajorVersion]
  exit 1
fi

min=$1
max=$2

function onError {
  echo Error: Wrong version of nodejs: current=`node --version` >&2
  echo "Error: Expected version: v$min <= current <= v$max" >&2
  return 2
}

current=`node --version | grep -oP '\d+' | head -n 1`

echo Current nodejs version: `node --version`
which node

if [ -n "$max" ]; then
  [ $current -ge $min -a $current -le $max ] || onError
else
  [ $current -ge $min ] || onError
fi
