#!/bin/bash

# Get required version
REQUIRED_NODE_VERSION=$(cat ./frontend-node/adv/frontend/services/yharnam/.nvmrc)

if [ -e ~/.nvm/nvm.sh ]; then
  . ~/.nvm/nvm.sh
  current=`nvm current &> /dev/null`
  nvm use $REQUIRED_NODE_VERSION &> /dev/null \
    && NODE_JS_BIN=`which node` \
    && NODE_JS_DIR=`dirname $NODE_JS_BIN` \
    && nvm use $current &> /dev/null \
    && export PATH=$NODE_JS_DIR:$PATH
else
  echo NVM is not found > /dev/stderr
  exit 1
fi

echo Current nodejs version: `node --version`
which node
