package Devel::QBitDebug;

use strict;
use warnings FATAL => 'all';

use utf8;
use open qw(:std :utf8);

use Devel::QBitDebug::ModuleReload;
use Devel::QBitDebug::Cache;
use Devel::QBitDebug::Printer;
use Devel::QBitDebug::Globals;
use Devel::QBitDebug::TrackCalls;
use Devel::QBitDebug::TrackTime;
use Devel::QBitDebug::MockAPIModels;

require "perl5db.pl";

$DB::deep = 500;

$DB::alias{x}     = 's/x/DB::px/';
$DB::alias{G}     = q{s/G(?:\s+(\S+))?(?:\s+(\S+))?(?:\s+(\S+))?/Devel::QBitDebug::Globals::G('$1', '$2', '$3')/};
$DB::alias{b_all} = q{s/b_all\s+(\S+)/Devel::QBitDebug::Globals::b_all('$1')/};

$DB::alias{track_method} =
  q{s/track_method\s+(\S+)(?:\s+(\S+))?/Devel::QBitDebug::TrackCalls::track_method('$1', '$2')/};
$DB::alias{track_sub}      = q{s/track_sub\s+(\S+)(?:\s+(\S+))?/Devel::QBitDebug::TrackCalls::track_sub('$1', '$2')/};
$DB::alias{untrack_sub}    = q{s/untrack_sub\s+(\S+)/Devel::QBitDebug::TrackCalls::untrack_sub('$1')/};
$DB::alias{untrack_method} = q{s/untrack_method\s+(\S+)/Devel::QBitDebug::TrackCalls::untrack_method('$1')/};

$DB::alias{track_rights}   = q{s/.*/Devel::QBitDebug::TrackCalls::track_method('QBit::Application::check_rights')/};
$DB::alias{untrack_rights} = q{s/.*/Devel::QBitDebug::TrackCalls::untrack_method('QBit::Application::check_rights')/};

$DB::alias{track_sql} =
  q{s/.*/Devel::QBitDebug::TrackCalls::track_method('QBit::Application::Model::DB::Query::get_sql_with_data')/};
$DB::alias{untrack_sql} =
  q{s/.*/Devel::QBitDebug::TrackCalls::untrack_method('QBit::Application::Model::DB::Query::get_sql_with_data')/};

$DB::alias{track_time}      = q{s/track_time\s+(\S+)/Devel::QBitDebug::TrackTime::track_time('$1')/};
$DB::alias{untrack_time}    = q{s/untrack_time\s+(\S+)/Devel::QBitDebug::TrackTime::untrack_time('$1')/};
$DB::alias{time_stat}       = q{s/time_stat.*/Devel::QBitDebug::TrackTime::time_stat/};
$DB::alias{time_stat_clear} = q{s/time_stat_clear.*/Devel::QBitDebug::TrackTime::time_stat_clear/};

$DB::alias{dump_to_file} = q{s/dump_to_file\s+(\S+)\s+(.+)/DB::dump_to_file($1, $2)/};

$DB::alias{Reload} = q{s/Reload/Devel::QBitDebug::ModuleReload::ReloadOnChange()/};
$DB::alias{reload} = q{s/reload/Devel::QBitDebug::ModuleReload::reload_on_change()/};

$DB::alias{MockAPIModels} = q{s/Reload/Devel::QBitDebug::MockAPIModels::MockAPIModels()/};

sub DB::afterinit {
    DB::parse_options('dieLevel=0 printRet=0');
    DB::open_stdout_handler($DB::OUT);

    if ($0 =~ m{\/qbit_fcgi_starter$}) {
        push(@DB::typeahead, "c FCGI::ProcManager::pm_pre_dispatch", "c QBit::WebInterface::FastCGI::run", "n",)
          unless $ENV{'DEBUG_FROM_START'};
        push(@DB::typeahead, "&Devel::QBitDebug::Cache::Cache;") if $ENV{'CACHE'};
        push(@DB::typeahead, "&Devel::QBitDebug::ModuleReload::ReloadOnChange;") if $ENV{'RELOAD'};

        my $previous_warn_handler = $SIG{__WARN__};
        $SIG{__WARN__} = sub {
            $previous_warn_handler->(@_)
              unless $_[0] =~
/Use of wide characters in FCGI::Stream::PRINT is deprecated and will stop working in a future version of FCGI/;
        };
    }
    push(@DB::typeahead, "&Devel::QBitDebug::MockAPIModels::MockAPIModels;") if $ENV{'MOCK_STAT'};
    push(@DB::typeahead, "c")                                                if $ENV{'NON_STOP'};
    push(@DB::typeahead, "q")                                                if $ENV{'EXIT'};
}

1;
