package Devel::QBitDebug::Cache;

use strict;
use warnings FATAL => 'all';
no warnings 'redefine';

use Data::Dumper;
use Clone qw(clone);

sub Cache {
    my ($self) = @_;

    use Memoize;

    my $method_normalizer = sub {Dumper(CORE::ref($_[0]), @_[1 .. $#_])};
    my $cur_user_normalizer = sub {({%{$self->get_option('cur_user') || {}}}->{login})};

    my $on_the_second_time = do {
        my $called = 0;
        sub {$called++ && 1;};
    };
    Memoize::memoize('QBit::Application::Model::API::Yandex::BlackBox::sessionid', NORMALIZER => $on_the_second_time);

    Memoize::memoize('QBit::Application::Model::RBAC::DB::get_cur_user_roles', NORMALIZER => $cur_user_normalizer);
    Memoize::memoize('QBit::Application::Model::RBAC::DB::get_roles_rights',   NORMALIZER => $method_normalizer);

    Memoize::memoize('JavaScript::V8::Context::eval', NORMALIZER => $method_normalizer);

    my @cur_user_subs_to_memoize = qw(
      WebInterface::_menu__devtools
      WebInterface::_menu__products
      WebInterface::_menu__statistics
      WebInterface::_menu__traffsrc

      Application::Model::Statistics::_get_tree
      );
    Memoize::memoize($_, NORMALIZER => $cur_user_normalizer) foreach @cur_user_subs_to_memoize;

    my $last_norm                      = '';
    my $_get_all_partner_db_normalizer = sub {
        my $standard_norm = Dumper(CORE::ref($_[1]), @_[2 .. $#_]);
        if ($_[2] eq 'SELECT FOUND_ROWS() AS `rows`') {
            return $standard_norm . $last_norm;
        } else {
            $last_norm = $standard_norm;
            return $standard_norm;
        }
    };

    require Tie::Memoize;
    our %_get_all_partner_db_cache;
    Memoize::memoize(
        '_get_all_partner_db',
        NORMALIZER   => $_get_all_partner_db_normalizer,
        SCALAR_CACHE => [HASH => \%_get_all_partner_db_cache],
        LIST_CACHE   => ['MERGE'],
    );

    no strict 'refs';

    my $_get_all = \&QBit::Application::Model::DB::_get_all;

    *{'QBit::Application::Model::DB::_get_all'} = sub {
        if (CORE::ref($_[0]) eq 'Application::Model::PartnerLogsDB'
            || $_[1] =~ /^SELECT LAST_INSERT_ID/)
        {
            return sub {
                return $_get_all->(@_);
              }
              ->(@_);
        } else {
            return &_get_all_partner_db($_get_all, @_);
        }
    };

    my $_do = \&QBit::Application::Model::DB::_do;

    *{'QBit::Application::Model::DB::_do'} = sub {
        if (CORE::ref($_[0]) ne 'Application::Model::PartnerLogsDB') {
            if (my ($table) = $_[1] =~ /`(\S+)`/) {
                delete($_get_all_partner_db_cache{$_}) foreach grep {/`$table`/} keys(%_get_all_partner_db_cache);
            }

            if ($_[1] =~ /DELETE|INSERT|REPLACE|TRUNCATE/) {
                Memoize::flush_cache($_) foreach @cur_user_subs_to_memoize;
            }
        }

        return $_do->(@_);
    };

    my $_memoizer = \&Memoize::_memoizer;
    *{'Memoize::_memoizer'} = sub {
        return clone($_memoizer->(@_));
    };

    #    $env{'non_stop'} = env{'non_stop'} if exists(env{'non_stop'});
    #    $env{'nonstop'} = true;
    #    $env{'accelerate'} = env{'accelerate'} if exists(env{'accelerate'});
    #    $env{'reload_on_change'} = env{'reload_on_change'} if exists(env{'reload_on_change'});

    DB::px('Memoization is enabled. Some features can work incorrect!');
}

sub _get_all_partner_db {
    my $_get_all = shift;

    return $_get_all->(@_);
}

1;
