package Devel::QBitDebug::Globals;

use strict;
use warnings FATAL => 'all';

use constant TRUE  => 1;
use constant FALSE => '';

sub G {
    my $regex            = shift || '.*';
    my $types_required   = shift || '';
    my $types_prohibited = shift || '';

    $types_prohibited = '' if $types_required;

    my %types_required;
    @types_required{split('', $types_required)} = ();
    my %types_prohibited;
    @types_prohibited{split('', $types_prohibited)} = ();

    my $sub_type_allowed = sub {
        my $type = shift;
        return TRUE if (!$types_required  && !$types_prohibited);
        return TRUE if ($types_required   && exists($types_required{$type}));
        return TRUE if ($types_prohibited && !exists($types_prohibited{$type}));
        return FALSE;
    };

    foreach my $module (sort keys %INC) {
        next unless $module =~ s/\.pm$//;
        $module =~ s'/'::'g;
        $module .= '::';

        no strict 'refs';
        foreach my $function (sort keys %{$module}) {
            my $full_name = $module . $function;
            eval {
                DB::p("\&$full_name\n")
                  if ($full_name =~ /$regex/) && defined(&$full_name) && $sub_type_allowed->('&');
            };
            eval {
                DB::p("\$$full_name\n")
                  if ($full_name =~ /$regex/) && defined($$full_name) && $sub_type_allowed->('$');
            };
            eval {
                DB::p("\@$full_name\n")
                  if ($full_name =~ /$regex/) && defined($full_name) && @$full_name && $sub_type_allowed->('@');
            };
            eval {
                DB::p("\%$full_name\n")
                  if ($full_name =~ /$regex/) && keys(%{$full_name}) && $sub_type_allowed->('%');
            };
            eval {
                DB::p("$full_name\n")
                  if ($full_name =~ /$regex/)
                  && $sub_type_allowed->('*')
                  && !(defined(&$full_name)
                    || defined($$full_name)
                    || (defined($full_name) && @$full_name)
                    || keys(%$full_name));
            };
        }
    }
}

sub b_all {
    my $regex = shift || '.*';

    foreach my $module (sort keys %INC) {
        next unless $module =~ s/\.pm$//;
        $module =~ s'/'::'g;
        $module .= '::';

        no strict 'refs';
        foreach my $function (sort keys %{$module}) {
            my $full_name = $module . $function;
            eval {
                if (($full_name =~ /$regex/) && defined(&$full_name))
                {
                    DB::cmd_b(undef, $full_name);
                    DB::p("\&$full_name\n");
                }
            };
            eval {
                if (
                    ($full_name =~ /$regex/)
                    && !(
                           defined(&$full_name)
                        || defined($$full_name)
                        || (defined($full_name) && @$full_name)
                        || keys(%$full_name)
                    )
                   )
                {
                    DB::cmd_b(undef, $full_name);
                    DB::p("$full_name\n");
                }
            };
        }
    }
}

1;
