package Devel::QBitDebug::MockAPIModels;

use strict;
use warnings FATAL => 'all';

use constant TRUE  => 1;
use constant FALSE => '';

use QBit::StringUtils;

sub MockAPIModels {
    no warnings 'redefine';
    no strict 'refs';

    *{'QBit::Application::Model::API::XMLRPC::call'} = sub {
        my ($self, $method, @opts) = @_;

        if ($self->can('log')) {
            my $name_module = ref($self);
            my @filter = ([name_module => '=' => \$name_module], [method => '=' => \$method],);
            push(@filter, [dt => '>=' => \("$opts[0] 00:00:00")], [dt => '<=' => \("$opts[1] 23:59:59")])
              if !grep {!($opts[$_] && !ref($opts[$_]) && $opts[$_] =~ /^([0-9]{4}-[0-9]{2}-[0-9]{2})$/)} 0 .. 1;

            my $log_data = $self->partner_logs_db->models_soap_api->get_all(
                fields => {content => {UNCOMPRESS => ['content']}},
                filter => [AND     => \@filter],
                order_by => [['dt', TRUE]],
                limit    => 1,
            )->[0];

            die "Can't mock $name_module $method.\n" unless $log_data;

            my $content = $log_data->{content};
            return $content ? from_json($content) : '';
        }
    };

    *{'QBit::Application::Model::API::HTTP::call'} = sub {
        my ($self, $method, %params) = @_;

        if ($self->can('log')) {
            my $name_module = ref($self);
            my @filter      = (
                [name_module => '='    => \$name_module],
                [url         => 'LIKE' => \(%params ? "%/$method?%" : "%/$method")],
                [dt          => '<='   => \(QBit::Date::name2date('daybeforeyesterday', oformat => 'db') . ' 23:59:59')]
            );

            my $log_data = $self->partner_logs_db->models_http_api->get_all(
                fields => {content => {UNCOMPRESS => ['content']}},
                filter => [AND     => \@filter],
                order_by => [['dt', TRUE]],
                limit    => 1,
            )->[0];

            die "Can't mock $name_module $method.\n" unless $log_data;

            my $content = $log_data->{content};
            return $content ? from_json($content) : '';
        }
    };

    DB::px('API Models are mocked.');
}

1;
