package Devel::QBitDebug::ModuleReload;

use strict;
use warnings FATAL => 'all';
no warnings 'redefine';

sub ReloadOnChange {
    no warnings::anywhere 'redefine';
    no strict 'refs';
    my $run = \&QBit::WebInterface::FastCGI::run;
    *{'QBit::WebInterface::FastCGI::run'} = sub {
        reload_on_change();
        return $run->(@_);
    };

    *{'QBit::WebInterface::Controller::unimport'} = sub {
        my ($self) = @_;

        my $package = ref($self) || $self;

        my $package_stash = QBit::Packages::package_stash($package);
        my %import_opts   = %{$package_stash->{import_opts}};
        my $path          = $import_opts{'path'};

        delete($package_stash->{$_}) foreach keys(%$package_stash);
        delete(QBit::Packages::package_stash('WebInterface')->{__CMDS__}->{$path});

        return %import_opts;
    };

    *{'Application::Model::Multistate::DBManager::unimport'} = sub {
        my ($self) = @_;

        my $package = ref($self) || $self;

        my $package_stash     = QBit::Packages::package_stash($package);
        my $application_stash = QBit::Packages::package_stash('Application')->{__MODELS__};

        my $accessor = {reverse(%$application_stash)}->{$package};
        delete($application_stash->{$accessor});
        delete(${Application::}{$accessor});
        delete($package_stash->{$_}) foreach keys(%$package_stash);

        return (accessor => $accessor);
    };

    DB::px('Reloading on change is enabled.');
}

my %Stat;
my $Debug = 0;

sub reload_on_change {
    my $perl_check_status;

    my $c = 0;
    while (my ($key, $file) = each %INC) {
        next if $file eq $INC{"Devel/QBitDebug/ModuleReload.pm"};    #too confusing
        local $^W = 0;
        my $mtime = (stat $file)[9];
        $Stat{$file} = $^T
          unless defined $Stat{$file};
        warn "Module::Reload: stat '$file' got $mtime >? $Stat{$file}\n"
          if $Debug >= 3;
        if ($mtime > $Stat{$file}) {
            unless (defined($perl_check_status)) {
                DB::px("\nModule changes detected. Checking...");
                $perl_check_status =
                  system(qw(perl -c -Ilib -Iframework_yndx/lib -e), 'use WebInterface; WebInterface->new()');
            }

            if ($perl_check_status == 0) {
                DB::px("Reload $key");
                delete $INC{$key};
                eval {
                    local $SIG{__WARN__} = \&warn;
                    my $package = $key;
                    if ($package =~ s/.pm$//) {
                        if ($package =~ s'/'::'g && $package->isa('WebInterface::Controller')) {
                            my %import_opts = $package->unimport();

                            package WebInterface;

                            require $key;
                            $package->import(%import_opts);

                            package Devel::QBitDebug::ModuleReload;
                        } elsif ($package->can('unimport')) {
                            my %import_opts = $package->unimport();

                            package Application;

                            require $key;
                            $package->import(%import_opts);

                            package Devel::QBitDebug::ModuleReload;
                        }
                    } else {
                        require $key;
                    }
                };
                if ($@) {
                    warn "Module::Reload: error during reload of '$key': $@\n";
                } elsif ($Debug) {
                    warn "Module::Reload: process $$ reloaded '$key'\n"
                      if $Debug == 1;
                    warn("Module::Reload: process $$ reloaded '$key' (\@INC=" . join(', ', @INC) . ")\n")
                      if $Debug >= 2;
                }
                ++$c;
            }
        }
        $Stat{$file} = $mtime;
    }
    return $c;
}

1;
