package Devel::QBitDebug::Printer;

package DB;

use strict;
use warnings FATAL => 'all';

use utf8;
use open qw(:std :utf8);

my $stdout_handler;

sub open_stdout_handler {
    open($stdout_handler, '>&', $_[0]);
}

sub p (@)  {print $stdout_handler @_;}
sub pf (@) {printf $stdout_handler @_;}

my %data_printer_opts = (
    color => {
        string => 'yellow',
        class  => 'green',
        method => 'green',
        undef  => 'red'
    },

    use_prototypes => 0,
    hash_separator => ' => ',
    index          => 0,
    return_value   => 'void',
    end_separator  => 1,
    deparse        => 1,
    quote_keys     => 'auto',
    sort_keys      => 1,
    class          => {
        internals    => 1,
        inherited    => 'all',
        universal    => 1,
        parents      => 1,
        linear_isa   => 'auto',
        expand       => 1,
        sort_methods => 1,
        show_methods => 'all'
    },
);

sub px {
    require Data::Printer;
    foreach (@_) {
        my $data = ref $_ ? $_ : \$_;
        Data::Printer::p($data, %data_printer_opts, output => $stdout_handler);
    }
    if (@_ > 1) {
        p("\n" . scalar(@_) . " entries in array.\n");
    } elsif (ref($_[0]) eq 'ARRAY' && @{$_[0]} > 1) {
        p("\n" . scalar(@{$_[0]}) . " entries in array reference.\n");
    }
}

sub p_tee {
    my $file = shift;

    &p;
    p_to_file($file, @_) if $file;
}

sub px_tee {
    my $file = shift;

    &px;
    px_to_file($file, @_) if $file;
}

sub p_to_file {
    my $file = shift;

    open(my $fh, '>>', $file);
    print $fh @_;
    close($fh);

    return;
}

sub px_to_file {
    my $file = shift;

    require Data::Dumper;
    local ($Data::Dumper::Terse) = 1;
    open(my $fh, '>>', $file);
    print $fh Data::Dumper::Dumper(@_), "\n";
    close($fh);

    return;
}

sub dump_to_file {
    my $file = shift;

    require Data::Printer;

    open(my $fh, '>', $file);
    close($fh);

    open($fh, '>>', $file);

    foreach (@_) {
        my $data = ref $_ ? $_ : \$_;
        Data::Printer::p(
            $data,
            %data_printer_opts,
            output => $fh,
            class  => {
                internals    => 0,
                inherited    => 'none',
                universal    => 0,
                parents      => 0,
                linear_isa   => 0,
                expand       => 0,
                sort_methods => 0,
                show_methods => 'none',
                deparse      => 0,
            },
        );
    }

    close($fh);

    px($file);
    p("\n");
    p(qx(tail $file));
}

1;
