package Devel::QBitDebug::TrackCalls;

use strict;
use warnings FATAL => 'all';

use Devel::QBitDebug;

my %tracked_subs;

sub track_method {
    _track_sub(1, @_);
}

sub track_sub {
    _track_sub(0, @_);
}

sub _track_sub {
    my ($first_arg, $sub_name, $file) = @_;

    my $sub = \&$sub_name;
    {
        no warnings 'redefine';
        no strict 'refs';
        *{$sub_name} = sub {
            my @args = @_[$first_arg .. $#_];
            DB::p_tee($file, "<Arguments:\n");
            DB::px_tee($file, @args);
            DB::p_tee($file, "Arguments>\n");

            if (wantarray() || !defined(wantarray())) {
                my @return = &$sub;
                DB::p_tee($file, "<Return:\n");
                DB::px_tee($file, @return);
                DB::p_tee($file, "Return>\n");

                return @return;
            } else {
                my $return = &$sub;
                DB::p_tee($file, "<Return:\n");
                DB::px_tee($file, $return);
                DB::p_tee($file, "Return>\n");

                return $return;
            }
        };
    }
    $tracked_subs{$sub_name} = $sub;
    if ($file) {
        require Cwd;
        DB::p 'Path to dump: ' . Cwd::abs_path($file) . "\n";
    }
}

sub untrack_method {
    &untrack_sub;
}

sub untrack_sub {
    my ($sub_name) = @_;

    my $sub_restore_sub = do {
        sub {
            my $sub_name = shift;

            no warnings 'redefine';
            no strict 'refs';
            *{$sub_name} = $tracked_subs{$sub_name};
            delete $tracked_subs{$sub_name};
        };
    };

    if ($sub_name eq '*') {
        foreach my $sub_name_expanded (keys %tracked_subs) {
            $sub_restore_sub->($sub_name_expanded);
        }
    } elsif (exists $tracked_subs{$sub_name}) {
        $sub_restore_sub->($sub_name);
    } else {
        die "Method $sub_name isn't tracked.";
    }
}

1;
