package Devel::QBitDebug::TrackTime;

use strict;
use warnings FATAL => 'all';

use constant TRUE  => 1;
use constant FALSE => '';

use Time::HiRes qw();

my %tracked_time;
my $last_time = 0;
my @time_records;
my %time_stat;

sub print_time_gain {
    my ($sub_name, $point) = @_;

    my $cur_time = Time::HiRes::time();

    if ($point eq 'end') {
        my $time_record = pop @time_records;
        $time_stat{$sub_name}{'quantity'} ||= 0;
        $time_stat{$sub_name}{'quantity'}++;
        $time_stat{$sub_name}{'time'} ||= 0;
        $time_stat{$sub_name}{'time'} += $cur_time - $time_record->{$sub_name};
    }
    my $offset .= ' ' x 4 x @time_records;

    if ($last_time) {
        DB::pf("%s%s (%s)\t%.3f\n", $offset, $sub_name, $point, $cur_time - $last_time);
    } else {
        DB::pf("%s%s (%s)\n", $offset, $sub_name, $point);
    }
    $last_time = $cur_time;

    push @time_records, {$sub_name => $cur_time} if $point eq 'begin';
}

sub time_stat {
    my $sum_time = 0;
    foreach (sort {$time_stat{$b}{'time'} <=> $time_stat{$a}{'time'}} keys %time_stat) {
        DB::pf("%s\t%d\t%.3f\n", $_, $time_stat{$_}{'quantity'}, $time_stat{$_}{'time'});
        $sum_time += $time_stat{$_}{'time'};
    }
    DB::p "TOTAL: $sum_time\n";
}

sub time_stat_clear {
    $last_time    = 0;
    @time_records = ();
    %time_stat    = ();
}

sub track_time {
    my ($sub_name, $begin, $end) = @_;
    $begin = $end = TRUE unless $begin || $end;

    my $sub = \&$sub_name;
    $tracked_time{$sub_name}{'sub'}   = $sub;
    $tracked_time{$sub_name}{'begin'} = $begin;
    $tracked_time{$sub_name}{'end'}   = $end;
    $last_time                        = 0;
    {
        no warnings 'redefine';
        no strict 'refs';
        *{$sub_name} = sub {
            print_time_gain($sub_name, 'begin') if $tracked_time{$sub_name}{'begin'};

            if (wantarray() || !defined(wantarray())) {
                my @return = &$sub;
                print_time_gain($sub_name, 'end') if $tracked_time{$sub_name}{'end'};

                return @return;
            } else {
                my $return = &$sub;
                print_time_gain($sub_name, 'end') if $tracked_time{$sub_name}{'end'};

                return $return;
            }
        };
    }
}

sub untrack_time {
    my ($sub_name) = @_;

    $last_time = 0;
    my $sub_restore_sub = do {
        sub {
            my $sub_name = shift;

            no warnings 'redefine';
            no strict 'refs';
            *{$sub_name} = $tracked_time{$sub_name}{'sub'};
            delete $tracked_time{$sub_name};
        };
    };

    if ($sub_name eq '*') {
        foreach my $sub_name (keys %tracked_time) {
            $sub_restore_sub->($sub_name);
        }
    } elsif (exists $tracked_time{$sub_name}) {
        $sub_restore_sub->($sub_name);
    } else {
        die "Method $sub_name isn't tracked.";
    }
}

1;
