#!/usr/bin/python3
# coding: utf-8

# docs: https://wiki.yandex-team.ru/geotargeting/libgeobase/http-export/
import requests
import csv

earth_id = 10000
russia_id = 225
cis_id = 166

regularity_dict = {
    111: 6000,
    138: 1000,
    166: 7000,
    183: 5000,
    225: 8000,
    241: 4000,
    10002: 3000,
    10003: 2000,
}


def _get_region_by_id(region_id):
    response_region_id = requests.get(
        f"http://geoexport.yandex.ru/?root={earth_id}&types=_all_&fields=id,parent_id,name,en_name&equals_search=id:{region_id}")
    region_rd = csv.reader(response_region_id.text.split('\n')[1:], delimiter="\t")
    for row in region_rd:
        return row


def _get_export_by_region(region_id, export_types):
    string_ints = [str(int) for int in export_types]
    types = ','.join(string_ints)
    response = requests.get(
        f"http://geoexport.yandex.ru/?root={region_id}&types={types}&fields=id,parent_id,name,en_name")
    rd = csv.reader(response.text.strip().split('\n')[1:], delimiter="\t")
    items = []
    for row in rd:
        items.append(row)

    return items


def _get_partner_geo_export():
    export_dict = {
        138: [1, 3],  # Australia and Oceania
        245: [1, 3],  # Arctic and Antarctic
        241: [1, 3],  # Africa
        183: [1, 3],  # Asia
        111: [1, 3],  # Europe
        10002: [1, 3],  # North America
        10003: [1, 3],  # South America
        cis_id: [1, 3],  # CIS
        russia_id: [1, 3, 4, 5],  # Russia
    }
    items = []
    for region_id in export_dict:
        items = items + _get_export_by_region(region_id, export_dict[region_id])

    items.append(_get_region_by_id(213))  # Moscow
    items.append(_get_region_by_id(2))  # Saint Petersburg
    items.append(_get_region_by_id(cis_id))  # CIS

    # They stay because now is a bad time to change them.
    ukraine_regions = [20525, 20524, 20526, 20527, 20528, 20550, 20529, 20530, 20531, 20532, 20533, 20534, 20535, 20538,
                       20536, 20537, 20539, 20540, 20541, 20542, 20543, 20545, 20544, 20549, 20548, 20547, 20546, 20552,
                       20551]
    for ukraine_region_id in ukraine_regions:
        items.append(_get_region_by_id(ukraine_region_id))

    return items


all_items = _get_partner_geo_export()
reg_dict = {}
for row in all_items:
    reg_id = row[0]
    if int(reg_id) == russia_id:
        row[1] = str(cis_id)  # change Russia parent to CIS
    reg_dict[reg_id] = row

for key in reg_dict:
    row = reg_dict[key]
    parent_id = row[1]
    while parent_id not in reg_dict and int(parent_id) != earth_id:
        parent_id = _get_region_by_id(parent_id)[1]
    row[1] = parent_id

for key in reg_dict:
    row = reg_dict[key]
    parent_id = row[1]
    level = 0
    while int(parent_id) != earth_id:
        sub_row = reg_dict.get(parent_id)
        parent_id = sub_row[1]
        level += 1
    geo_id = row[0]
    name_en = row[3].replace("'", "\\'")
    name_ru = row[2]
    if int(row[1]) == earth_id:
        parent_id = 'NULL'
    else:
        parent_id = row[1]
    regularity = regularity_dict.get(int(geo_id), 0)
    print(f"INSERT INTO `geo_base` SET `id` = {geo_id}, `level` = {level}, `name_en` = '{name_en}', " \
          f"`name_ru` = '{name_ru}', `parent_id` = {parent_id}, `regularity` = {regularity};")
