#!/usr/bin/env bash
set -ex

export DEBIAN_FRONTEND=noninteractive

tmpfs_size="1G"

cat <<EOF > /etc/hosts
::1 localhost
EOF

apt-get update
apt-get install -y python-software-properties iptables=1.4.21-2ubuntu6 

# Install ansible
echo "INSTALL ANSIBLE"
add-apt-repository ppa:ansible/ansible
apt-get update
apt-get install -y ansible

echo "CLONE PARTNER_ANSIBLE"
git clone https://github.yandex-team.ru/partner/partner_ansible.git ansible

cd ansible

echo "UPDATE ANSIBLE HOSTS"
rm hosts
cat <<EOF > hosts
[dev]
localhost
[main-dev]
localhost
EOF

echo "ANSIBLE PLAY"
ansible-playbook -i ./hosts --connection=local --tags "lxc" partner2-dev-servers
ansible-playbook -i ./hosts --connection=local --tags "lxc" pi-secrets
ansible-playbook -i ./hosts --connection=local --tags "lxc" partner2_release_robot
ansible-playbook -i ./hosts --connection=local install_lib_Partner_PR
ansible-playbook -i ./hosts --connection=local install_lib_Partner_DB
ansible-playbook -i ./hosts --connection=local install_lib_Yandex_StarTrek
ansible-playbook -i ./hosts --connection=local install_carton.yaml
mkdir /usr/share/partners
mkdir /usr/share/partners/bin
ansible-playbook -i ./hosts --connection=local install-partner-db-haproxy

