# -*- coding: utf-8 -*-
from flask import request
from passport.backend.core.env import Environment
from passport.backend.core.portallib import get_net
from werkzeug.http import parse_cookie


def add_env():
    request.env = APIEnvironment.from_request(request)


def _get_header(headers, name, alternate_name, default=None):
    header = headers.get(name, headers.get(alternate_name, default))
    return header


class APIEnvironment(Environment):
    @classmethod
    def from_request(cls, request):
        consumer_ip = _get_header(
            request.environ,
            'HTTP_YA_CONSUMER_REAL_IP',
            'HTTP_X_REAL_IP',
            default=request.environ['REMOTE_ADDR'],
        )
        user_ip = get_net(request.environ.get('HTTP_YA_CONSUMER_CLIENT_IP', consumer_ip), request.headers)['real_ip']

        ya_client_cookies = request.environ.get('HTTP_YA_CLIENT_COOKIE')
        cookies = {}
        if ya_client_cookies:
            cookies = parse_cookie(ya_client_cookies)

        return cls(
            cookies=cookies,
            user_ip=user_ip,
            consumer_ip=consumer_ip,
            user_agent=_get_header(request.environ, 'HTTP_YA_CLIENT_USER_AGENT', 'HTTP_USER_AGENT'),
            host=_get_header(request.environ, 'HTTP_YA_CLIENT_HOST', 'HTTP_HOST'),
            authorization=_get_header(request.environ, 'HTTP_YA_CONSUMER_AUTHORIZATION', 'HTTP_AUTHORIZATION'),
        )
