# -*- coding: utf-8 -*-

from passport.backend.core.logging_utils.loggers.statbox import StatboxLogEntry
from passport.backend.core.logging_utils.loggers.tskv import TskvLogger


class AdmStatboxLogEntry(StatboxLogEntry):
    """
    От паспортного StatboxLogEntry отличается специфичным для админки форматом.
    """
    def __init__(self, **params):
        params.setdefault('tskv_format', 'passport-adminka-log')
        super(AdmStatboxLogEntry, self).__init__(**params)


class AdmStatboxLogger(TskvLogger):
    default_logger_name = 'statbox'
    entry_class = AdmStatboxLogEntry
