# -*- coding: utf-8 -*-

from passport.backend.core.conf import settings
from passport.backend.core.lazy_loader import (
    lazy_loadable,
    LazyLoader,
)
from yt.wrapper import YtClient


@lazy_loadable('YtDt')
class YtDt(object):
    def __init__(self, table_path):
        self.yt_client = YtClient(proxy=settings.YT_PROXY, token=settings.YT_TOKEN)
        self.table_path = table_path
        self.mounted = False

    # Используется поколоночное хранение в чанках, поэтому columns имеет смысл задавать всегда - быстрее чтение
    def get(self, condition, columns=None):
        if not self.mounted:
            self.yt_client.mount_table(self.table_path)
            self.mounted = True
        columns = '*' if columns is None else ', '.join(columns)
        return self.yt_client.select_rows(
            '{columns} from [{table_path}] where {condition}'.format(
                columns=columns,
                table_path=self.table_path,
                condition=condition,
            ),
        )

    def get_by_uid(self, uid, columns=None):
        r = list(self.get('uid = %du' % uid, columns=columns))
        if len(r) > 0:
            return r[0]
        return

    def get_by_yandexuid(self, yandexuid, columns=None):  # pragma: no cover
        return list(self.get('yandexuid = "%s"' % yandexuid, columns=columns))


def get_yt_dt():
    return LazyLoader.get_instance('YtDt', table_path=settings.YT_BOTNETIA_TABLE_PATH)
