# -*- coding: utf-8 -*-
import os

from passport.backend.library.configurator import Configurator
import yenv


def is_debug():
    current_user = os.environ.get('USER', os.environ.get('LOGNAME', 'root'))
    return yenv.type == 'development' and current_user not in ('root', 'www-data')


config = Configurator(
    'passport-adm-api',
    configs=[
        'base.yaml',
        'devserver.yaml' if is_debug() else {},
    ],
)
