# -*- coding: utf-8 -*-
from copy import deepcopy

from frozendict import frozendict
from passport.backend.utils.common import deep_merge
import yenv

from .secrets import (
    DB_PASSWORD,
    DB_SLAVE_PASSWORD,
    DB_SLAVE_USER,
    DB_USER,
)


_DB_MASTER_CONFIG = {
    'localhost': {
        'testing': frozendict({
            'passportdbcentral': frozendict({
                'master': frozendict({
                    'host': 'cnt-dbm-test.passport.yandex.net',
                    'database': 'passportdbcentral',
                    'user': DB_USER,
                    'password': DB_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 2,
                    'retries': 3,
                    'type': 'master',
                    'driver': 'mysql',
                }),
            }),
            'passportdbshard1': frozendict({
                'master': frozendict({
                    'host': 'cnt-dbm-test.passport.yandex.net',
                    'database': 'passportdbshard1',
                    'user': DB_USER,
                    'password': DB_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 2,
                    'retries': 3,
                    'type': 'master',
                    'driver': 'mysql',
                }),
            }),
            'passportdbshard2': frozendict({
                'master': frozendict({
                    'host': 'cnt-dbm-test.passport.yandex.net',
                    'database': 'passportdbshard2',
                    'user': DB_USER,
                    'password': DB_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 2,
                    'retries': 3,
                    'type': 'master',
                    'driver': 'mysql',
                }),
            }),
        }),
        'production': {},  # нужно для тестов в CI и Sandbox
    },
    'intranet': {
        'production': frozendict({
            'passportdbcentral': frozendict({
                'master': frozendict({
                    'host': 'cnt-dbm.passport.yandex.net',
                    'database': 'passportdbcentral',
                    'user': DB_USER,
                    'password': DB_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 1,
                    'retries': 2,
                    'type': 'master',
                    'driver': 'mysql',
                }),
            }),
            'passportdbshard1': frozendict({
                'master': frozendict({
                    'host': 'sh1-dbm.passport.yandex.net',
                    'database': 'passportdbshard1',
                    'user': DB_USER,
                    'password': DB_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 1,
                    'retries': 2,
                    'type': 'master',
                    'driver': 'mysql',
                }),
            }),
            'passportdbshard2': frozendict({
                'master': frozendict({
                    'host': 'sh1-dbm.passport.yandex.net',
                    'database': 'passportdbshard2',
                    'user': DB_USER,
                    'password': DB_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 1,
                    'retries': 2,
                    'type': 'master',
                    'driver': 'mysql',
                }),
            }),
            'passportdbshard3': frozendict({
                'master': frozendict({
                    'host': 'sh3-dbm.passport.yandex.net',
                    'database': 'passportdbshard3',
                    'user': DB_USER,
                    'password': DB_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 1,
                    'retries': 2,
                    'type': 'master',
                    'driver': 'mysql',
                }),
            }),
            'passportdbshard4': frozendict({
                'master': frozendict({
                    'host': 'sh3-dbm.passport.yandex.net',
                    'database': 'passportdbshard4',
                    'user': DB_USER,
                    'password': DB_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 1,
                    'retries': 2,
                    'type': 'master',
                    'driver': 'mysql',
                }),
            }),
        }),
    },
}

_DB_CONFIG = {
    'localhost': {
        'testing': {
            'passportdbcentral': {
                'slave': {
                    'host': 'cnt-dbs-test-adm.passport.yandex.net',
                    'database': 'passportdbcentral',
                    'user': DB_SLAVE_USER,
                    'password': DB_SLAVE_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 2,
                    'retries': 3,
                    'retry_timeout': 0.5,
                    'type': 'slave',
                    'driver': 'mysql',
                },
            },
            'passportdbshard1': {
                'slave': {
                    'host': 'cnt-dbs-test-adm.passport.yandex.net',
                    'database': 'passportdbshard1',
                    'user': DB_SLAVE_USER,
                    'password': DB_SLAVE_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 2,
                    'retries': 3,
                    'retry_timeout': 0.5,
                    'type': 'slave',
                    'driver': 'mysql',
                },
            },
            'passportdbshard2': {
                'slave': {
                    'host': 'cnt-dbs-test-adm.passport.yandex.net',
                    'database': 'passportdbshard2',
                    'user': DB_SLAVE_USER,
                    'password': DB_SLAVE_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 2,
                    'retries': 3,
                    'retry_timeout': 0.5,
                    'type': 'slave',
                    'driver': 'mysql',
                },
            },
        },
        'production': {},  # нужно для тестов в CI и Sandbox
    },
    'intranet': {
        'production': {
            'passportdbcentral': {
                'slave': {
                    'host': 'cnt-dbs-adm-%(dc)s1.passport.yandex.net',
                    'database': 'passportdbcentral',
                    'user': DB_SLAVE_USER,
                    'password': DB_SLAVE_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 2,
                    'retries': 3,
                    'retry_timeout': 0.5,
                    'type': 'slave',
                    'driver': 'mysql',
                },
            },
            'passportdbshard1': {
                'slave': {
                    'host': 'sh1-dbs-adm-%(dc)s1.passport.yandex.net',
                    'database': 'passportdbshard1',
                    'user': DB_SLAVE_USER,
                    'password': DB_SLAVE_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 2,
                    'retries': 3,
                    'retry_timeout': 0.5,
                    'type': 'slave',
                    'driver': 'mysql',
                },
            },
            'passportdbshard2': {
                'slave': {
                    'host': 'sh1-dbs-adm-%(dc)s1.passport.yandex.net',
                    'database': 'passportdbshard2',
                    'user': DB_SLAVE_USER,
                    'password': DB_SLAVE_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 2,
                    'retries': 3,
                    'retry_timeout': 0.5,
                    'type': 'slave',
                    'driver': 'mysql',
                },
            },
            'passportdbshard3': {
                'slave': {
                    'host': 'cnt-dbs-adm-%(dc)s1.passport.yandex.net',
                    'database': 'passportdbshard3',
                    'user': DB_SLAVE_USER,
                    'password': DB_SLAVE_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 2,
                    'retries': 3,
                    'retry_timeout': 0.5,
                    'type': 'slave',
                    'driver': 'mysql',
                },
            },
            'passportdbshard4': {
                'slave': {
                    'host': 'cnt-dbs-adm-%(dc)s1.passport.yandex.net',
                    'database': 'passportdbshard4',
                    'user': DB_SLAVE_USER,
                    'password': DB_SLAVE_PASSWORD,
                    'port': 3306,
                    'connect_timeout': 1,
                    'read_timeout': 1,
                    'write_timeout': 2,
                    'retries': 3,
                    'retry_timeout': 0.5,
                    'type': 'slave',
                    'driver': 'mysql',
                },
            },
        },
    },
}

_DB_CONFIG = deep_merge(_DB_CONFIG, _DB_MASTER_CONFIG)

_DB_CONFIG['intranet']['rc'] = _DB_CONFIG['intranet']['production']
_DB_CONFIG['localhost']['development'] = _DB_CONFIG['localhost']['testing']

DB_CONFIG = _DB_CONFIG[yenv.name][yenv.type]

PING_DB_NAMES = DB_CONFIG.keys()
