# -*- coding: utf-8 -*-

from collections import namedtuple


_host = namedtuple('host', 'name id dc')

# список хостов с полным доменным именем, идентификатором и датацентром
# отсортирован по id!
HOSTS = [_host(name=name, id=id, dc=dc) for name, id, dc in [
    ('webadmin-s1.passport.yandex.net', 0x3B, 's'),
    ('webadmin-f1.passport.yandex.net', 0x3F, 'f'),
    ('webadmin-m1.passport.yandex.net', 0x42, 'm'),
    ('python-dev1.passport.yandex.net', 0x7F, 'myt'),
    ('python-dev2.passport.yandex.net', 0x7F, 'myt'),
    ('adm-test.yandex-team.ru', 0x7F, 'myt'),
]]
