# -*- coding: utf-8 -*-
import os

import yenv


_current_user = os.environ.get('USER', os.environ.get('LOGNAME', 'root'))

if yenv.type == 'development' and _current_user not in ('root', 'www-data'):
    DEBUG = True
else:
    DEBUG = False  # pragma: no cover

APP_LOGGER_NAME = 'api.requests.flask'

LOG_PATH = '' if DEBUG else '/var/log/yandex/passport-adm-api/'
HISTORYDB_LOG_PATH = LOG_PATH + 'historydb.' if DEBUG else LOG_PATH + 'historydb/'
STATBOX_LOG_PATH = LOG_PATH + 'statbox.' if DEBUG else LOG_PATH + 'statbox/'

LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'filters': {
        'request_id': {
            '()': 'passport.backend.core.logging_utils.filters.RequestIdFilter',
        },
    },
    'formatters': {
        'default': {
            'format': '%(process)d %(asctime)s %(name)-15s %(levelname)-10s %(message)s',
        },
        'request': {
            'format': '%(asctime)s %(request_id)s %(name)-15s %(levelname)-10s %(message)s',
        },
        'simple': {
            'format': "%(message)s",
        },
    },
    'root': {
        'handlers': ['passport.debug', 'passport.warning', 'exception'],
        'level': 'DEBUG',
    },
    'handlers': {
        'console': {
            'class': 'logging.StreamHandler',
            'level': 'DEBUG',
            'formatter': 'request',
            'filters': ['request_id'],
        },
        'exception': {
            'class': 'passport.backend.core.logging_utils.handlers.ExceptionHandler',
            'level': 'ERROR',
            'log_path': LOG_PATH,
            'filters': ['request_id'],
        },
        'historydb.event': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': HISTORYDB_LOG_PATH + 'event.log',
            'formatter': 'simple',
        },
        'statbox': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': STATBOX_LOG_PATH + 'statbox.log',
            'formatter': 'simple',
        },
        'passport.debug': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': LOG_PATH + 'debug.log',
            'formatter': 'request',
            'filters': ['request_id'],
            'level': 'DEBUG',
        },
        'passport.warning': {
            'class': 'ylog.handlers.OSFileHandler',
            'filename': LOG_PATH + 'warning.log',
            'formatter': 'request',
            'filters': ['request_id'],
            'level': 'WARNING',
        },
    },
    'loggers': {
        # Логгер для сторонней библиотеки requests
        'requests': {
            'handlers': ['passport.warning'],
            'level': 'WARNING',
            'propagate': False,
        },

        # Наши, родные, логгеры
        'api.requests.error': {'handlers': ['exception']},
        'passport_adm_api': {
            'handlers': ['passport.debug', 'passport.warning', 'exception'],
            'level': 'INFO',
            'propagate': False,
        },
        'historydb.event': {
            'handlers': ['historydb.event'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'statbox': {
            'handlers': ['statbox'],
            'level': 'DEBUG',
            'propagate': False,
        },
        'passport.initialize': {
            'handlers': ['passport.debug', 'passport.warning'],
            'level': 'INFO',
            'propagate': False,
        },
        'passport.useragent': {
            'handlers': ['passport.debug', 'passport.warning', 'exception'],
            'level': 'INFO',
            'propagate': False,
        },
    },
}


if DEBUG:
    LOGGING['root']['handlers'].append('console')
    LOGGING['loggers']['passport_adm_api']['handlers'].append('console')
    LOGGING['handlers']['exception'] = {
        'class': 'logging.FileHandler',
        'filename': 'exception.log',
        'formatter': 'default',
    }
