# -*- coding: utf-8 -*-
# isort:skip_file
import os
from imp import load_source

secret_settings = None

for config_file in (
    '/usr/lib/yandex/passport-adm-secrets/local_settings.py',
    os.path.join(os.path.dirname(__file__), 'default.py'),
):
    try:
        secret_settings = load_source('secret_settings', config_file)
        break
    except IOError:
        pass

if not secret_settings:
    from passport.backend.adm_api.settings.secrets import default as secret_settings


# логин-пароль для rw-доступа к БД
DB_USER = secret_settings.DB_USER
DB_PASSWORD = secret_settings.DB_PASSWORD

# логин-пароль для ro-доступа к БД
DB_SLAVE_USER = secret_settings.DB_SLAVE_USER
DB_SLAVE_PASSWORD = secret_settings.DB_SLAVE_PASSWORD
# OAuth-токен для YT
YT_TOKEN = secret_settings.YT_TOKEN
