# -*- coding: utf-8 -*-

from passport.backend.core.validators import (
    PublicId,
    RequireSome,
    Schema,
    String,
    StringBoolean,
    Uid,
)


class UidForm(Schema):
    uid = Uid()


class AuthsForm(UidForm):
    password_auths = StringBoolean(if_missing=None, not_empty=True)


class UidFormWithComment(UidForm):
    comment = String(if_missing=None, not_empty=True, strip=True)


class PublicIdForm(UidFormWithComment):
    public_id = PublicId(not_empty=True)


class IsVerifiedForm(UidFormWithComment):
    is_verified = StringBoolean(not_empty=True)


class TakeoutSubscriptionForm(UidFormWithComment):
    takeout_subscription = StringBoolean(not_empty=True)


class TakeoutDeleteSubscriptionForm(UidFormWithComment):
    takeout_delete_subscription = StringBoolean(not_empty=True)


class Sms2FAForm(UidFormWithComment):
    sms_2fa = StringBoolean(not_empty=True, if_missing=None)
    forbid_disabling_sms_2fa = StringBoolean(not_empty=True, if_missing=None)

    chained_validators = [
        RequireSome(
            ['sms_2fa', 'forbid_disabling_sms_2fa'],
            min_=1, max_=2,
        ),
    ]
