# -*- coding: utf-8 -*-

from passport.backend.core.validators import (
    RequireSome,
    RestoreIdValidator,
    Schema,
    StringBool,
    Uid,
)


class RestoreSemiAutoAttemptForm(Schema):
    restore_id = RestoreIdValidator()


class RestoreSemiAutoSupportDecisionForm(Schema):
    restore_id = RestoreIdValidator()

    passed = StringBool(not_empty=True)

    regenerate_link = StringBool(if_missing=False)


class UidOrRestoreIdForm(Schema):
    restore_id = RestoreIdValidator(if_missing=None)
    uid = Uid(if_missing=None)

    chained_validators = [
        RequireSome(some_fields=['restore_id', 'uid']),
    ]


class RestoreSemiAutoAttemptsForm(UidOrRestoreIdForm):
    pass


class RestoreAccountStateForm(UidOrRestoreIdForm):
    pass
