import argparse

from passport.backend.api.app import execute_app
from passport.backend.api.configs import config
from passport.backend.library.wsgi_runner import Runner


def main():
    parser = argparse.ArgumentParser(description='Run passport API')
    parser.add_argument('--port', type=int, help='bind port')
    args = parser.parse_args()
    if args.port:
        config['application']['port'] = args.port
    app = execute_app()
    runner = Runner(
        app,
        config=config,
    )
    runner.run()
