# -*- coding: utf-8 -*-

# Маппинг из полей формы passport.backend.api.forms.base.DeviceInfoForm в поля трека
from collections import namedtuple


DEVICE_PARAM_NAME_TO_TRACK_FIELD = {
    'am_version': 'account_manager_version',
    'am_version_name': 'account_manager_version',
    'app_id': 'device_application',
    'app_platform': 'device_os_id',
    'os_version': 'device_os_version',
    'app_version': 'device_application_version',
    'app_version_name': 'device_application_version',
    'manufacturer': 'device_manufacturer',
    'model': 'device_hardware_model',
    'uuid': 'device_app_uuid',
    'deviceid': 'device_hardware_id',
    'ifv': 'device_ifv',
    'device_id': 'device_id',
    'device_name': 'device_name',
}
DEVICE_INFO_TRACK_FIELDS = sorted(DEVICE_PARAM_NAME_TO_TRACK_FIELD.values())

AmPlatform = namedtuple('AmPlatform', ['UNKNOWN', 'IOS', 'ANDROID'])._make([0, 1, 2])


def device_params_to_track_fields(app_params):
    track_fields = dict()
    for param_name, track_field_name in DEVICE_PARAM_NAME_TO_TRACK_FIELD.items():
        if app_params.get(param_name):
            track_fields[track_field_name] = app_params[param_name]
    return track_fields


def get_device_params_from_track(track):
    """Получить из трека параметры, переданные АМ"""
    return dict(
        (field_name, getattr(track, field_name))
        for field_name in DEVICE_INFO_TRACK_FIELDS
        if getattr(track, field_name) is not None
    )


def form_to_oauth_params(form_values):
    retval = {}
    for oauth_name in DEVICE_PARAM_NAME_TO_TRACK_FIELD:
        if oauth_name in form_values:
            retval[oauth_name] = form_values[oauth_name]
    return retval


def track_to_oauth_params(params):
    """
    Переименовать параметры трека в параметры oauth.
    """
    retval = {}
    for oauth_name, track_name in DEVICE_PARAM_NAME_TO_TRACK_FIELD.items():
        if track_name in params:
            retval[oauth_name] = params[track_name]
    return retval


def get_am_version(track):
    return (track.account_manager_version or '').strip().lower()


def get_am_platform(track):
    am_platform = (track.device_os_id or '').strip().lower()
    if am_platform in {'iphone', 'ipad', 'ipod', 'apple'}:
        return AmPlatform.IOS
    elif 'android' in am_platform:
        return AmPlatform.ANDROID
    else:
        return AmPlatform.UNKNOWN
