# -*- coding: utf-8 -*-
import logging
import uuid

from passport.backend.core.conf import settings
from passport.backend.core.historydb.converter import AuthChallengeEntryConverter
from passport.backend.core.historydb.entry import AuthChallengeEntry
import yenv


auth_challenge_log = logging.getLogger('historydb.auth_challenge')

UPDATED_ACTION = 'updated'


def write_profile_to_log(uid, profile):
    comment = None
    if settings.WRITE_YENV_TO_AUTH_CHALLENGE_LOG:
        comment = 'env=%s' % yenv.type

    entry = AuthChallengeEntry(
        UPDATED_ACTION,
        uid,
        str(uuid.UUID(bytes=profile.timeuuid)),
        profile.raw_env,
        comment,
    )
    auth_challenge_log.debug(AuthChallengeEntryConverter().convert(entry))
