# -*- coding: utf-8 -*-


def add_grants(grant_list, if_arg, default_values=None):
    def grants_function(*fargs, **kwargs):
        return grant_list if fargs[0].get(if_arg) not in default_values else []
    if default_values is None:
        default_values = [None, False]
    return grants_function


def generate_subscription_grant(grants, service):
    return ['subscription.%s.%s' % (grant, service.slug) for grant in grants]


def add_grants_for_service(grants):
    def grants_function(*args, **kwargs):
        service = args[0].get('service')
        if service is not None:
            return generate_subscription_grant(grants, service)
        return []
    return grants_function


__all__ = (
    'add_grants',
    'add_grants_for_service',
    'generate_subscription_grant',
)
